/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.io.File;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskArtifactStateRepository.class);
    private final TaskHistoryRepository taskHistoryRepository;
    private final FileSnapshotter outputFilesSnapshotter;
    private final FileSnapshotter inputFilesSnapshotter;
    private final Instantiator instantiator;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, FileSnapshotter outputFilesSnapshotter, FileSnapshotter inputFilesSnapshotter) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.inputFilesSnapshotter = inputFilesSnapshotter;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private TaskUpToDateState states;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate() {
            List<String> messages = this.getChangeMessages(this.getStates().getAllTaskChanges());
            if (messages.isEmpty()) {
                this.upToDate = true;
                LOGGER.info("Skipping {} as it is up-to-date.", this.task);
                return true;
            }
            this.logUpToDateMessages(messages, "Executing");
            return false;
        }

        public boolean canPerformIncrementalBuild() {
            List<String> messages = this.getChangeMessages(this.getStates().getRebuildChanges());
            if (messages.isEmpty()) {
                LOGGER.info("Executing {} against out-of-date files only.", this.task);
                return true;
            }
            this.logUpToDateMessages(messages, "All files are considered out-of-date for");
            return false;
        }

        private List<String> getChangeMessages(TaskStateChanges stateChanges) {
            ArrayList<String> messages = new ArrayList<String>();
            for (TaskStateChange stateChange : stateChanges) {
                messages.add(stateChange.getMessage());
            }
            return messages;
        }

        private void logUpToDateMessages(List<String> messages, String action) {
            if (LOGGER.isInfoEnabled()) {
                Formatter formatter = new Formatter();
                formatter.format("%s %s due to:", action, this.task);
                for (String message : messages) {
                    formatter.format("%n  %s", message);
                }
                LOGGER.info(formatter.toString());
            }
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            if (this.canPerformIncrementalBuild()) {
                return (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{this.getStates().getInputFilesChanges()});
            }
            return (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
        }

        @Override
        public boolean hasHistory() {
            return this.history.getPreviousExecution() != null;
        }

        @Override
        public FileCollection getOutputFiles() {
            TaskExecution lastExecution = this.history.getPreviousExecution();
            return lastExecution != null && lastExecution.getOutputFilesSnapshot() != null ? lastExecution.getOutputFilesSnapshot().getFiles() : new SimpleFileCollection(new File[0]);
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        public void beforeTask() {
        }

        @Override
        public void afterTask() {
            if (this.upToDate) {
                return;
            }
            this.getStates().getAllTaskChanges().snapshotAfterTask();
            this.history.update();
        }

        @Override
        public void finished() {
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                this.states = new TaskUpToDateState(this.task, this.history, DefaultTaskArtifactStateRepository.this.outputFilesSnapshotter, DefaultTaskArtifactStateRepository.this.inputFilesSnapshotter);
            }
            return this.states;
        }
    }
}

