/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.EvalutationOperation;
import org.gradle.profile.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile {
    private final Project project;
    private ProjectState state;
    private HashMap<Task, TaskExecution> tasks = new HashMap();
    private final ContinuousOperation evaluation;

    public ProjectProfile(Project project) {
        this.project = project;
        this.evaluation = new EvalutationOperation(project);
    }

    public TaskExecution getTaskProfile(Task task) {
        TaskExecution result = this.tasks.get(task);
        if (result == null) {
            result = new TaskExecution(task);
            this.tasks.put(task, result);
        }
        return result;
    }

    public CompositeOperation<TaskExecution> getTasks() {
        return new CompositeOperation<TaskExecution>(this.tasks.values());
    }

    public String getPath() {
        return this.project.getPath();
    }

    public ContinuousOperation getEvaluation() {
        return this.evaluation;
    }

    public ProjectState getState() {
        return this.state;
    }

    public void setState(ProjectState state) {
        this.state = state;
    }
}

