/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileIntegrityViolationException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.InsufficientLockModeException;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockManager.class);
    private static final int DEFAULT_LOCK_TIMEOUT = 60000;
    private static final byte STATE_REGION_PROTOCOL = 1;
    private static final int STATE_REGION_SIZE = 2;
    private static final int STATE_REGION_POS = 0;
    private static final byte INFORMATION_REGION_PROTOCOL = 2;
    private static final int INFORMATION_REGION_POS = 2;
    public static final int INFORMATION_REGION_SIZE = 2048;
    public static final int INFORMATION_REGION_DESCR_CHUNK_LIMIT = 340;
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;
    private final int lockTimeoutMs;

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider) {
        this(metaDataProvider, 60000);
    }

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs) {
        this.metaDataProvider = metaDataProvider;
        this.lockTimeoutMs = lockTimeoutMs;
    }

    public FileLock lock(File target, FileLockManager.LockMode mode, String targetDisplayName) throws LockTimeoutException {
        return this.lock(target, mode, targetDisplayName, "");
    }

    public FileLock lock(File target, FileLockManager.LockMode mode, String targetDisplayName, String operationDisplayName) {
        if (mode == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", new Object[]{mode}));
        }
        File canonicalTarget = GFileUtils.canonicalise(target);
        if (!this.lockedFiles.add(canonicalTarget)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", targetDisplayName));
        }
        try {
            return new DefaultFileLock(canonicalTarget, mode, targetDisplayName, operationDisplayName);
        }
        catch (Throwable t) {
            this.lockedFiles.remove(canonicalTarget);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private RandomAccessFile lockFileAccess;
        private boolean integrityViolated;

        public DefaultFileLock(File target, FileLockManager.LockMode mode, String displayName, String operationDisplayName) throws Throwable {
            if (mode == FileLockManager.LockMode.None) {
                throw new UnsupportedOperationException("Locking mode None is not supported.");
            }
            this.target = target;
            this.displayName = displayName;
            this.operationDisplayName = operationDisplayName;
            this.lockFile = target.isDirectory() ? new File(target, target.getName() + ".lock") : new File(target.getParentFile(), target.getName() + ".lock");
            GFileUtils.mkdirs(this.lockFile.getParentFile());
            this.lockFile.createNewFile();
            this.lockFileAccess = new RandomAccessFile(this.lockFile, "rw");
            try {
                this.lock = this.lock(mode);
                this.integrityViolated = !this.getUnlockedCleanly();
            }
            catch (Throwable t) {
                this.lockFileAccess.close();
                throw t;
            }
            this.mode = this.lock.isShared() ? FileLockManager.LockMode.Shared : FileLockManager.LockMode.Exclusive;
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            this.assertOpen();
            try {
                this.lockFileAccess.seek(1L);
                if (!this.lockFileAccess.readBoolean()) {
                    return false;
                }
            }
            catch (EOFException e) {
                return false;
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            return true;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            return (T)action.create();
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            this.doWriteAction(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            this.assertOpen();
            this.doWriteAction(action);
        }

        private void doWriteAction(Runnable action) {
            if (this.mode != FileLockManager.LockMode.Exclusive) {
                throw new InsufficientLockModeException("An exclusive lock is required for this operation");
            }
            try {
                this.integrityViolated = true;
                this.markDirty();
                action.run();
                this.markClean();
                this.integrityViolated = false;
            }
            catch (Throwable t) {
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        private void assertOpenAndIntegral() {
            this.assertOpen();
            if (this.integrityViolated) {
                throw new FileIntegrityViolationException(String.format("The file '%s' was not unlocked cleanly", this.target));
            }
        }

        private void markClean() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(true);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        private void markDirty() throws IOException {
            this.lockFileAccess.seek(0L);
            this.lockFileAccess.writeByte(1);
            this.lockFileAccess.writeBoolean(false);
            assert (this.lockFileAccess.getFilePointer() == 2L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.lockFileAccess == null) {
                return;
            }
            try {
                LOGGER.debug("Releasing lock on {}.", (Object)this.displayName);
                DefaultFileLockManager.this.lockedFiles.remove(this.target);
                try {
                    if (this.lock != null && !this.lock.isShared()) {
                        this.lockFileAccess.setLength(2L);
                    }
                }
                finally {
                    this.lockFileAccess.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error releasing lock on {}: {}", (Object)this.displayName, (Object)e);
            }
            finally {
                this.lock = null;
                this.lockFileAccess = null;
            }
        }

        @Override
        public FileLockManager.LockMode getMode() {
            return this.mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private java.nio.channels.FileLock lock(FileLockManager.LockMode lockMode) throws Throwable {
            java.nio.channels.FileLock stateRegionLock;
            block19: {
                LOGGER.debug("Waiting to acquire {} lock on {}.", (Object)lockMode.toString().toLowerCase(), (Object)this.displayName);
                long timeout = System.currentTimeMillis() + (long)DefaultFileLockManager.this.lockTimeoutMs;
                stateRegionLock = this.lockStateRegion(lockMode, timeout);
                if (stateRegionLock == null) {
                    String ownerPid = "unknown";
                    String ownerOperation = "unknown";
                    java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Shared, timeout);
                    if (informationRegionLock == null) {
                        LOGGER.debug("Could not lock information region for {}. Ignoring.", (Object)this.displayName);
                    } else {
                        try {
                            if (this.lockFileAccess.length() <= 2L) {
                                LOGGER.debug("Lock file for {} is too short to contain information region. Ignoring.", (Object)this.displayName);
                            } else {
                                this.lockFileAccess.seek(2L);
                                if (this.lockFileAccess.readByte() != 2) {
                                    throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                                }
                                ownerPid = this.lockFileAccess.readUTF();
                                ownerOperation = this.lockFileAccess.readUTF();
                            }
                        }
                        finally {
                            informationRegionLock.release();
                        }
                    }
                    throw new LockTimeoutException(String.format("Timeout waiting to lock %s. It is currently in use by another Gradle instance.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", this.displayName, ownerPid, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), ownerOperation, this.operationDisplayName, this.lockFile));
                }
                try {
                    java.nio.channels.FileLock informationRegionLock;
                    if (this.lockFileAccess.length() > 0L) {
                        this.lockFileAccess.seek(0L);
                        if (this.lockFileAccess.readByte() != 1) {
                            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file '%s' for %s.", this.lockFile, this.displayName));
                        }
                    }
                    if (stateRegionLock.isShared()) break block19;
                    if (this.lockFileAccess.length() < 2L) {
                        this.lockFileAccess.seek(0L);
                        this.lockFileAccess.writeByte(1);
                        this.lockFileAccess.writeBoolean(false);
                    }
                    if ((informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, timeout)) == null) {
                        throw new IllegalStateException(String.format("Timeout waiting to lock the information region for lock %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.seek(2L);
                        this.lockFileAccess.writeByte(2);
                        this.lockFileAccess.writeUTF(this.trimIfNecessary(DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier()));
                        this.lockFileAccess.writeUTF(this.trimIfNecessary(this.operationDisplayName));
                        this.lockFileAccess.setLength(this.lockFileAccess.getFilePointer());
                    }
                    finally {
                        informationRegionLock.release();
                    }
                }
                catch (Throwable t) {
                    stateRegionLock.release();
                    throw t;
                }
            }
            LOGGER.debug("Lock acquired.");
            return stateRegionLock;
        }

        private String trimIfNecessary(String inputString) {
            if (inputString.length() > 340) {
                return inputString.substring(0, 340);
            }
            return inputString;
        }

        private java.nio.channels.FileLock lockStateRegion(FileLockManager.LockMode lockMode, long timeout) throws IOException, InterruptedException {
            return this.lockRegion(lockMode, timeout, 0L, 2L);
        }

        private java.nio.channels.FileLock lockInformationRegion(FileLockManager.LockMode lockMode, long timeout) throws IOException, InterruptedException {
            return this.lockRegion(lockMode, timeout, 2L, 2046L);
        }

        private java.nio.channels.FileLock lockRegion(FileLockManager.LockMode lockMode, long timeout, long start, long size) throws IOException, InterruptedException {
            do {
                java.nio.channels.FileLock fileLock;
                if ((fileLock = this.lockFileAccess.getChannel().tryLock(start, size, lockMode == FileLockManager.LockMode.Shared)) != null) {
                    return fileLock;
                }
                Thread.sleep(200L);
            } while (System.currentTimeMillis() < timeout);
            return null;
        }
    }
}

