/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.StartParameter;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.changedetection.CacheBackedFileSnapshotRepository;
import org.gradle.api.internal.changedetection.CacheBackedTaskHistoryRepository;
import org.gradle.api.internal.changedetection.CacheLockHandlingTaskExecuter;
import org.gradle.api.internal.changedetection.CachingHasher;
import org.gradle.api.internal.changedetection.DefaultFileCacheListener;
import org.gradle.api.internal.changedetection.DefaultFileSnapshotter;
import org.gradle.api.internal.changedetection.DefaultHasher;
import org.gradle.api.internal.changedetection.DefaultTaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.DefaultTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.FileCacheBroadcastTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.ShortCircuitTaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter;
import org.gradle.api.internal.tasks.execution.ExecuteAtMostOnceTaskExecuter;
import org.gradle.api.internal.tasks.execution.PostExecutionAnalysisTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipEmptySourceFilesTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipOnlyIfTaskExecuter;
import org.gradle.api.internal.tasks.execution.SkipTaskWithNoActionsExecuter;
import org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter;
import org.gradle.api.internal.tasks.execution.ValidatingTaskExecuter;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.listener.ListenerManager;

public class TaskExecutionServices
extends DefaultServiceRegistry {
    private final Gradle gradle;

    public TaskExecutionServices(ServiceRegistry parent, Gradle gradle) {
        super(parent);
        this.gradle = gradle;
    }

    protected TaskExecuter createTaskExecuter() {
        return new ExecuteAtMostOnceTaskExecuter(new SkipOnlyIfTaskExecuter(new SkipTaskWithNoActionsExecuter(new SkipEmptySourceFilesTaskExecuter(new ValidatingTaskExecuter(new SkipUpToDateTaskExecuter(new CacheLockHandlingTaskExecuter(new PostExecutionAnalysisTaskExecuter(new ExecuteActionsTaskExecuter(((ListenerManager)this.get(ListenerManager.class)).getBroadcaster(TaskActionListener.class))), (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class)), (TaskArtifactStateRepository)this.get(TaskArtifactStateRepository.class)))))));
    }

    protected TaskArtifactStateCacheAccess createCacheAccess() {
        return new DefaultTaskArtifactStateCacheAccess(this.gradle, (CacheRepository)this.get(CacheRepository.class));
    }

    protected TaskArtifactStateRepository createTaskArtifactStateRepository() {
        TaskArtifactStateCacheAccess cacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        DefaultFileSnapshotter fileSnapshotter = new DefaultFileSnapshotter(new CachingHasher(new DefaultHasher(), cacheAccess));
        OutputFilesSnapshotter outputFilesSnapshotter = new OutputFilesSnapshotter(fileSnapshotter, (IdGenerator<Long>)new RandomLongIdGenerator(), cacheAccess);
        CacheBackedTaskHistoryRepository taskHistoryRepository = new CacheBackedTaskHistoryRepository(cacheAccess, new CacheBackedFileSnapshotRepository(cacheAccess));
        return new FileCacheBroadcastTaskArtifactStateRepository(new ShortCircuitTaskArtifactStateRepository((StartParameter)this.get(StartParameter.class), new DefaultTaskArtifactStateRepository(taskHistoryRepository, fileSnapshotter, outputFilesSnapshotter)), new DefaultFileCacheListener());
    }

    protected TaskPlanExecutor createTaskExecutorFactory() {
        StartParameter startParameter = this.gradle.getStartParameter();
        TaskArtifactStateCacheAccess cacheAccess = (TaskArtifactStateCacheAccess)this.get(TaskArtifactStateCacheAccess.class);
        return new TaskPlanExecutorFactory(cacheAccess, startParameter.getParallelThreadCount()).create();
    }
}

