/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.copy.ZipCompressor;

abstract class AbstractZipCompressor
implements ZipCompressor {
    AbstractZipCompressor() {
    }

    public abstract int getCompressedMethod();

    public ZipOutputStream createArchiveOutputStream(File destination) {
        try {
            ZipOutputStream outStream = new ZipOutputStream(destination);
            outStream.setMethod(this.getCompressedMethod());
            return outStream;
        }
        catch (Exception e) {
            String message = String.format("Unable to create ZIP output stream for file %s.", destination);
            throw new UncheckedIOException(message, (Throwable)e);
        }
    }
}

