/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import org.apache.commons.lang.StringUtils;
import org.gradle.StartParameter;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private static final Logger LOGGER = Logging.getLogger(ShortCircuitTaskArtifactStateRepository.class);
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, TaskArtifactStateRepository repository) {
        this.startParameter = startParameter;
        this.repository = repository;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        if (task.getOutputs().getHasOutput()) {
            return new ShortCircuitArtifactState(task, this.repository.getStateFor(task));
        }
        LOGGER.info(String.format("%s has not declared any outputs, assuming that it is out-of-date.", StringUtils.capitalize((String)task.toString())));
        return new NoHistoryArtifactState();
    }

    private class ShortCircuitArtifactState
    implements TaskArtifactState {
        private final TaskInternal task;
        private final TaskArtifactState state;

        public ShortCircuitArtifactState(TaskInternal task, TaskArtifactState state) {
            this.task = task;
            this.state = state;
        }

        public boolean isUpToDate() {
            return !ShortCircuitTaskArtifactStateRepository.this.startParameter.isRerunTasks() && this.task.getOutputs().getUpToDateSpec().isSatisfiedBy((Object)this.task) && this.state.isUpToDate();
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this.state.getExecutionHistory();
        }

        public void beforeTask() {
            this.state.beforeTask();
        }

        public void afterTask() {
            this.state.afterTask();
        }

        public void finished() {
            this.state.finished();
        }
    }

    private static class NoHistoryArtifactState
    implements TaskArtifactState,
    TaskExecutionHistory {
        private NoHistoryArtifactState() {
        }

        public boolean isUpToDate() {
            return false;
        }

        public void beforeTask() {
        }

        public void afterTask() {
        }

        public void finished() {
        }

        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        public FileCollection getOutputFiles() {
            throw new UnsupportedOperationException();
        }
    }
}

