/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    private final Map<Object, byte[]> entries = new HashMap<Object, byte[]>();
    private final Serializer<V> valueSerializer;

    public InMemoryIndexedCache(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public V get(K key) {
        byte[] serialised = this.entries.get(key);
        if (serialised == null) {
            return null;
        }
        try {
            ByteArrayInputStream instr = new ByteArrayInputStream(serialised);
            return (V)this.valueSerializer.read((InputStream)instr);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void put(K key, V value) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        try {
            this.valueSerializer.write((OutputStream)outstr, value);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.entries.put(key, outstr.toByteArray());
    }

    @Override
    public void remove(K key) {
        this.entries.remove(key);
    }
}

