/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.gradle.api.internal.changedetection.Hasher;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.messaging.serialize.DataStreamBackedSerializer;

public class CachingHasher
implements Hasher {
    private final PersistentIndexedCache<File, FileInfo> cache;
    private final Hasher hasher;
    private long timestamp;

    public CachingHasher(Hasher hasher, TaskArtifactStateCacheAccess cacheAccess) {
        this.hasher = hasher;
        this.cache = cacheAccess.createCache("fileHashes", File.class, FileInfo.class, new FileInfoSerializer());
    }

    public byte[] hash(File file) {
        FileInfo info = this.cache.get(file);
        long length = file.length();
        this.timestamp = file.lastModified();
        if (info != null && length == info.length && this.timestamp == info.timestamp) {
            return info.hash;
        }
        byte[] hash = this.hasher.hash(file);
        this.cache.put(file, new FileInfo(hash, length, this.timestamp));
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    extends DataStreamBackedSerializer<FileInfo> {
        private FileInfoSerializer() {
        }

        public FileInfo read(DataInput input) throws IOException {
            int hashLength = input.readInt();
            byte[] hash = new byte[hashLength];
            input.readFully(hash);
            long timestamp = input.readLong();
            long length = input.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        public void write(DataOutput output, FileInfo value) throws IOException {
            output.writeInt(value.hash.length);
            output.write(value.hash);
            output.writeLong(value.timestamp);
            output.writeLong(value.length);
        }
    }

    public static class FileInfo
    implements Serializable {
        private final byte[] hash;
        private final long timestamp;
        private final long length;

        public FileInfo(byte[] hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

