/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

public class DependencyClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;

    public DependencyClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    public ClassPath findClassPath(String name) {
        if (name.equals(DependencyFactory.ClassPathNotation.GRADLE_API.name())) {
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            Module core = this.moduleRegistry.getModule("gradle-core");
            for (Module module : core.getAllRequiredModules()) {
                classpath = classpath.plus(module.getClasspath());
            }
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-core-impl").getClasspath());
            try {
                classpath = classpath.plus(this.moduleRegistry.getModule("gradle-tooling-api").getImplementationClasspath());
            }
            catch (UnknownModuleException e) {
                // empty catch block
            }
            for (Module pluginModule : this.pluginModuleRegistry.getPluginModules()) {
                classpath = classpath.plus(pluginModule.getClasspath());
            }
            return classpath;
        }
        if (name.equals(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.name())) {
            return this.moduleRegistry.getExternalModule("groovy-all").getClasspath();
        }
        return null;
    }
}

