/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.Nullable;
import org.gradle.api.internal.AbstractPolymorphicDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolymorphicDomainObjectContainer<T>
extends AbstractPolymorphicDomainObjectContainer<T>
implements ExtensiblePolymorphicDomainObjectContainer<T> {
    @Nullable
    private NamedDomainObjectFactory<? extends T> defaultFactory;
    private final Map<Class<?>, NamedDomainObjectFactory<?>> factories = new HashMap();

    public DefaultPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    public DefaultPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator) {
        this(type, instantiator, (Namer<T>)Named.Namer.forType(type));
    }

    @Override
    protected T doCreate(String name) {
        if (this.defaultFactory == null) {
            throw new InvalidUserDataException("This container does not support creating domain objects without specifying a type.");
        }
        return this.defaultFactory.create(name);
    }

    @Override
    protected <U extends T> U doCreate(String name, Class<U> type) {
        NamedDomainObjectFactory<?> factory = this.factories.get(type);
        if (factory == null) {
            throw new InvalidUserDataException(String.format("This container does not support creating domain objects of type '%s'.", type.getName()));
        }
        return (U)factory.create(name);
    }

    public void registerDefaultFactory(NamedDomainObjectFactory<? extends T> factory) {
        this.defaultFactory = factory;
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        if (!this.getType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Factory element type '%s' is not a subtype of container element type '%s'", type.getName(), this.getType().getName()));
        }
        this.factories.put(type, factory);
    }
}

