/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.PolymorphicDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolymorphicDomainObjectContainer<T>
extends AbstractNamedDomainObjectContainer<T>
implements PolymorphicDomainObjectContainer<T> {
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();
    private final Convention convention;
    private final DynamicObject dynamicObject;

    protected AbstractPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
        this.convention = new DefaultConvention(instantiator);
        this.dynamicObject = new ExtensibleDynamicObject((Object)this, (AbstractDynamicObject)new ContainerDynamicObject(this.elementsDynamicObject), this.convention);
    }

    protected AbstractPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator) {
        this(type, instantiator, (Namer<T>)Named.Namer.forType(type));
    }

    protected abstract <U extends T> U doCreate(String var1, Class<U> var2);

    @Override
    public <U extends T> U create(String name, Class<U> type) {
        return this.create(name, type, null);
    }

    @Override
    public <U extends T> U create(String name, Class<U> type, Action<? super U> configuration) {
        this.assertCanAdd(name);
        U object = this.doCreate(name, type);
        this.add(object);
        if (configuration != null) {
            configuration.execute(object);
        }
        return object;
    }

    @Override
    public Convention getConvention() {
        return this.convention;
    }

    @Override
    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    @Override
    protected Object createConfigureDelegate(Closure configureClosure) {
        return new PolymorphicDomainObjectContainerConfigureDelegate(configureClosure.getOwner(), this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        protected String getDisplayName() {
            return AbstractPolymorphicDomainObjectContainer.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String name) {
            return AbstractPolymorphicDomainObjectContainer.this.findByName(name) != null;
        }

        @Override
        public Object getProperty(String name) throws MissingPropertyException {
            Object object = AbstractPolymorphicDomainObjectContainer.this.findByName(name);
            if (object == null) {
                return super.getProperty(name);
            }
            return object;
        }

        public Map<String, T> getProperties() {
            return AbstractPolymorphicDomainObjectContainer.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
            if (this.isConfigureMethod(name, arguments)) {
                return ConfigureUtil.configure((Closure)arguments[arguments.length - 1], AbstractPolymorphicDomainObjectContainer.this.getByName(name));
            }
            return super.invokeMethod(name, arguments);
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return (arguments.length == 1 && arguments[0] instanceof Closure || arguments.length == 2 && arguments[0] instanceof Class && arguments[1] instanceof Closure) && this.hasProperty(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerDynamicObject
    extends CompositeDynamicObject {
        private ContainerDynamicObject(ContainerElementsDynamicObject elementsDynamicObject) {
            this.setObjects(new BeanDynamicObject(AbstractPolymorphicDomainObjectContainer.this), elementsDynamicObject, AbstractPolymorphicDomainObjectContainer.this.getConvention().getExtensionsAsDynamicObject());
        }

        @Override
        protected String getDisplayName() {
            return AbstractPolymorphicDomainObjectContainer.this.getDisplayName();
        }
    }
}

