/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.internal.Factory;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationLogger.class);
    private static final Set<String> PLUGINS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> TASKS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> METHODS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> DYNAMIC_PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> NAMED_PARAMETERS = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final ThreadLocal<Boolean> LOG_TRACE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";
    private static String deprecationMessage;
    private static Lock deprecationMessageLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeprecationMessage() {
        if (deprecationMessage == null) {
            deprecationMessageLock.lock();
            try {
                if (deprecationMessage == null) {
                    String messageBase = "has been deprecated and is scheduled to be removed in";
                    GradleVersion currentVersion = GradleVersion.current();
                    int versionMajor = currentVersion.getMajor();
                    String when = versionMajor == -1 ? "the next major version of Gradle" : String.format("Gradle %d.0", versionMajor + 1);
                    deprecationMessage = String.format("%s %s", messageBase, when);
                }
            }
            finally {
                deprecationMessageLock.unlock();
            }
        }
        return deprecationMessage;
    }

    public static void reset() {
        PLUGINS.clear();
        METHODS.clear();
        PROPERTIES.clear();
        NAMED_PARAMETERS.clear();
        DYNAMIC_PROPERTIES.clear();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (DeprecationLogger.isEnabled() && PLUGINS.add(pluginName)) {
            LOGGER.warn(String.format("The %s plugin %S. Please use the %s plugin instead.", pluginName, DeprecationLogger.getDeprecationMessage(), replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        if (DeprecationLogger.isEnabled() && TASKS.add(taskName)) {
            LOGGER.warn(String.format("The %s task type %s. Please use the %s instead.", taskName, DeprecationLogger.getDeprecationMessage(), replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (DeprecationLogger.isEnabled() && METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method %s. Please use the %s method instead.", methodName, DeprecationLogger.getDeprecationMessage(), replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(propertyName)) {
            LOGGER.warn(String.format("The %s property %s. Please use the %s property instead.", propertyName, DeprecationLogger.getDeprecationMessage(), replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (DeprecationLogger.isEnabled() && METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method %s.", methodName, DeprecationLogger.getDeprecationMessage()));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(propertyName)) {
            LOGGER.warn(String.format("The %s property %s. %s", propertyName, DeprecationLogger.getDeprecationMessage(), advice));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (DeprecationLogger.isEnabled() && NAMED_PARAMETERS.add(parameterName)) {
            LOGGER.warn(String.format("The %s named parameter %s. Please use the %s named parameter instead.", parameterName, DeprecationLogger.getDeprecationMessage(), replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserWith(String message) {
        if (DeprecationLogger.isEnabled() && METHODS.add(message)) {
            LOGGER.warn(message);
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDeprecated(String thing) {
        DeprecationLogger.nagUserWith(String.format("%s %s", thing, DeprecationLogger.getDeprecationMessage()));
    }

    public static void nagUserOfDeprecated(String thing, String explanation) {
        DeprecationLogger.nagUserWith(String.format("%s %s. %s.", thing, DeprecationLogger.getDeprecationMessage(), explanation));
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        DeprecationLogger.nagUserOfDeprecated(String.format("%s. This behaviour", behaviour));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isTraceLoggingEnabled() {
        return Boolean.getBoolean(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME) || LOG_TRACE.get() != false;
    }

    private static void logTraceIfNecessary() {
        if (DeprecationLogger.isTraceLoggingEnabled()) {
            StackTraceElement[] stack;
            for (StackTraceElement frame : stack = StackTraceUtils.sanitize((Throwable)new Exception()).getStackTrace()) {
                if (frame.getClassName().startsWith(DeprecationLogger.class.getName())) continue;
                LOGGER.warn("    {}", (Object)frame.toString());
            }
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setLogTrace(boolean flag) {
        LOG_TRACE.set(flag);
    }

    public static void nagUserAboutDynamicProperty(String propertyName, Object target, Object value) {
        if (!DeprecationLogger.isEnabled()) {
            return;
        }
        DeprecationLogger.nagUserOfDeprecated("Creating properties on demand (a.k.a. dynamic properties)", "Please read http://gradle.org/docs/current/dsl/org.gradle.api.plugins.ExtraPropertiesExtension.html for information on the replacement for dynamic properties");
        String propertyWithClass = target.getClass().getName() + "." + propertyName;
        if (DYNAMIC_PROPERTIES.add(propertyWithClass)) {
            String propertyWithTarget = String.format("\"%s\" on \"%s\"", propertyName, target);
            String theValue = value == null ? "null" : StringUtils.abbreviate((String)value.toString(), (int)25);
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property: %s, value: \"%s\".", propertyWithTarget, theValue));
        } else {
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property \"%s\" created in multiple locations.", propertyName));
        }
    }

    static {
        deprecationMessageLock = new ReentrantLock();
    }
}

