/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.util.ClasspathSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderBackedClasspathSource
implements ClasspathSource {
    private final ClassLoader classLoader;

    public ClassLoaderBackedClasspathSource(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void collectClasspath(Collection<? super URL> classpath) {
        ClassLoader stopAt = ClassLoader.getSystemClassLoader() == null ? null : ClassLoader.getSystemClassLoader().getParent();
        for (ClassLoader cl = this.classLoader; cl != null && cl != stopAt; cl = cl.getParent()) {
            if (cl instanceof ClasspathSource) {
                ClasspathSource classpathSource = (ClasspathSource)((Object)cl);
                classpathSource.collectClasspath(classpath);
                break;
            }
            if (!(cl instanceof URLClassLoader)) continue;
            classpath.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        }
    }
}

