/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.invocation.Gradle;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.DependencyResolveProfile;
import org.gradle.profile.Operation;
import org.gradle.profile.ProjectProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildProfile {
    private final Gradle gradle;
    private final Map<Project, ProjectProfile> projects = new LinkedHashMap<Project, ProjectProfile>();
    private final Map<String, DependencyResolveProfile> dependencySets = new LinkedHashMap<String, DependencyResolveProfile>();
    private long profilingStarted;
    private long buildStarted;
    private long settingsEvaluated;
    private long projectsLoaded;
    private long projectsEvaluated;
    private long buildFinished;
    private boolean successful;

    public BuildProfile(Gradle gradle) {
        this.gradle = gradle;
    }

    public Gradle getGradle() {
        return this.gradle;
    }

    public long getBuildStarted() {
        return this.buildStarted;
    }

    public String getTaskDescription() {
        StringBuilder result = new StringBuilder();
        for (String name : this.gradle.getStartParameter().getExcludedTaskNames()) {
            result.append("-x");
            result.append(name);
            result.append(" ");
        }
        for (String name : this.gradle.getStartParameter().getTaskNames()) {
            result.append(name);
            result.append(" ");
        }
        return result.toString();
    }

    public ProjectProfile getProjectProfile(Project project) {
        ProjectProfile result = this.projects.get(project);
        if (result == null) {
            result = new ProjectProfile(project);
            this.projects.put(project, result);
        }
        return result;
    }

    public List<ProjectProfile> getProjects() {
        return new ArrayList<ProjectProfile>(this.projects.values());
    }

    public CompositeOperation<Operation> getProjectConfiguration() {
        ArrayList<ContinuousOperation> operations = new ArrayList<ContinuousOperation>();
        for (ProjectProfile projectProfile : this.projects.values()) {
            operations.add(projectProfile.getEvaluation());
        }
        return new CompositeOperation<Operation>(operations);
    }

    public DependencyResolveProfile getDependencySetProfile(ResolvableDependencies dependencySet) {
        DependencyResolveProfile profile = this.dependencySets.get(dependencySet.getPath());
        if (profile == null) {
            profile = new DependencyResolveProfile(dependencySet);
            this.dependencySets.put(dependencySet.getPath(), profile);
        }
        return profile;
    }

    public CompositeOperation<DependencyResolveProfile> getDependencySets() {
        return new CompositeOperation<DependencyResolveProfile>(this.dependencySets.values());
    }

    public void setProfilingStarted(long profilingStarted) {
        this.profilingStarted = profilingStarted;
    }

    public void setBuildStarted(long buildStarted) {
        this.buildStarted = buildStarted;
    }

    public void setSettingsEvaluated(long settingsEvaluated) {
        this.settingsEvaluated = settingsEvaluated;
    }

    public void setProjectsLoaded(long projectsLoaded) {
        this.projectsLoaded = projectsLoaded;
    }

    public void setProjectsEvaluated(long projectsEvaluated) {
        this.projectsEvaluated = projectsEvaluated;
    }

    public void setBuildFinished(long buildFinished) {
        this.buildFinished = buildFinished;
    }

    public long getElapsedStartup() {
        return this.buildStarted - this.profilingStarted;
    }

    public long getElapsedTotal() {
        return this.buildFinished - this.profilingStarted;
    }

    public long getElapsedSettings() {
        return this.settingsEvaluated - this.buildStarted;
    }

    public long getElapsedProjectsLoading() {
        return this.projectsLoaded - this.settingsEvaluated;
    }

    public long getElapsedProjectsEvaluated() {
        return this.projectsEvaluated - this.projectsLoaded;
    }

    public long getElapsedAfterProjectsEvaluated() {
        return this.buildFinished - this.projectsEvaluated;
    }

    public long getElapsedTotalExecutionTime() {
        long result = 0L;
        for (ProjectProfile projectProfile : this.projects.values()) {
            result += projectProfile.getTasks().getElapsedTime();
        }
        return result;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }
}

