/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.DefaultClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedApplicationClassLoaderWorker
implements Callable<Void>,
Serializable {
    private final Action<WorkerContext> worker;
    private final Collection<URI> applicationClassPath;

    public IsolatedApplicationClassLoaderWorker(Collection<URI> applicationClassPath, Action<WorkerContext> worker) {
        this.applicationClassPath = applicationClassPath;
        this.worker = worker;
    }

    @Override
    public Void call() throws Exception {
        final ClassLoader applicationClassLoader = this.createApplicationClassLoader();
        WorkerContext context = new WorkerContext(){

            public ClassLoader getApplicationClassLoader() {
                return applicationClassLoader;
            }
        };
        this.worker.execute((Object)context);
        return null;
    }

    private ClassLoader createApplicationClassLoader() {
        return new DefaultClassLoaderFactory().createIsolatedClassLoader(this.applicationClassPath);
    }
}

