/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerProcessBuilder {
    private final JavaExecHandleBuilder javaCommand;
    private final Set<String> packages = new HashSet<String>();
    private final Set<File> applicationClasspath = new LinkedHashSet<File>();
    private Action<? super WorkerProcessContext> action;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private boolean loadApplicationInSystemClassLoader;

    public WorkerProcessBuilder(FileResolver fileResolver) {
        this.javaCommand = new JavaExecHandleBuilder(fileResolver);
    }

    public WorkerProcessBuilder applicationClasspath(Iterable<File> files) {
        GUtil.addToCollection(this.applicationClasspath, files);
        return this;
    }

    public Set<File> getApplicationClasspath() {
        return this.applicationClasspath;
    }

    public WorkerProcessBuilder sharedPackages(String ... packages) {
        this.sharedPackages(Arrays.asList(packages));
        return this;
    }

    public WorkerProcessBuilder sharedPackages(Iterable<String> packages) {
        GUtil.addToCollection(this.packages, packages);
        return this;
    }

    public Set<String> getSharedPackages() {
        return this.packages;
    }

    public WorkerProcessBuilder worker(Action<? super WorkerProcessContext> action) {
        this.action = action;
        return this;
    }

    public Action<? super WorkerProcessContext> getWorker() {
        return this.action;
    }

    public JavaExecHandleBuilder getJavaCommand() {
        return this.javaCommand;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isLoadApplicationInSystemClassLoader() {
        return this.loadApplicationInSystemClassLoader;
    }

    public void setLoadApplicationInSystemClassLoader(boolean loadApplicationInSystemClassLoader) {
        this.loadApplicationInSystemClassLoader = loadApplicationInSystemClassLoader;
    }

    public abstract WorkerProcess build();
}

