/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import org.gradle.StartParameter;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.BuildFileProjectSpec;
import org.gradle.initialization.BuildSourceBuilder;
import org.gradle.initialization.DefaultProjectSpec;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectDirectoryProjectSpec;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;

public class SettingsHandler {
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;
    private BuildSourceBuilder buildSourceBuilder;

    public SettingsHandler(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        AbstractProjectSpec spec;
        StartParameter startParameter = gradle.getStartParameter();
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter);
        File explicitProjectDir = startParameter.getProjectDir();
        File explicitBuildFile = startParameter.getBuildFile();
        AbstractProjectSpec abstractProjectSpec = explicitBuildFile != null ? new BuildFileProjectSpec(explicitBuildFile) : (spec = explicitProjectDir == null ? new DefaultProjectSpec(startParameter.getCurrentDir()) : new ProjectDirectoryProjectSpec(explicitProjectDir));
        if (!spec.containsProject(settings.getProjectRegistry())) {
            StartParameter noSearchParameter = startParameter.newInstance();
            noSearchParameter.useEmptySettings();
            settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter);
            if (settings == null) {
                throw new InternalError("Empty settings file does not contain expected project.");
            }
            if (noSearchParameter.getBuildFile() != null) {
                ProjectDescriptor rootProject = settings.getRootProject();
                assert (noSearchParameter.getBuildFile().getParentFile().equals(rootProject.getProjectDir()));
                rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
            }
        }
        gradle.getScriptClassLoader().addParent(settings.getClassLoader());
        return settings;
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        StartParameter buildSrcStartParameter = startParameter.newBuild();
        buildSrcStartParameter.setCurrentDir(new File(settingsLocation.getSettingsDir(), "buildSrc"));
        URLClassLoader buildSourceClassLoader = this.buildSourceBuilder.buildAndCreateClassLoader(buildSrcStartParameter);
        return this.loadSettings(gradle, settingsLocation, buildSourceClassLoader, startParameter);
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }

    private SettingsInternal loadSettings(GradleInternal gradle, SettingsLocation settingsLocation, URLClassLoader buildSourceClassLoader, StartParameter startParameter) {
        return this.settingsProcessor.process(gradle, settingsLocation, buildSourceClassLoader, startParameter);
    }
}

