/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.StatementLabelsDeprecationLogger;

public class StatementLabelsScriptTransformer
extends AbstractScriptTransformer {
    protected int getPhase() {
        return 5;
    }

    public String getId() {
        return "labels";
    }

    public void call(final SourceUnit source) throws CompilationFailedException {
        final ArrayList logStats = Lists.newArrayList();
        this.visitScriptCode(source, (GroovyCodeVisitor)new ClassCodeVisitorSupport(){

            protected SourceUnit getSourceUnit() {
                return source;
            }

            protected void visitStatement(Statement statement) {
                if (statement.getStatementLabel() != null) {
                    String label = statement.getStatementLabel();
                    String sample = source.getSample(statement.getLineNumber(), statement.getColumnNumber(), null);
                    StaticMethodCallExpression logExpr = new StaticMethodCallExpression(ClassHelper.makeWithoutCaching(StatementLabelsDeprecationLogger.class), "log", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)label), (Expression)new ConstantExpression((Object)sample)));
                    logStats.add(new ExpressionStatement((Expression)logExpr));
                }
            }
        });
        source.getAST().getStatementBlock().addStatements((List)logStats);
    }
}

