/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.SetMultimap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectFinderByTaskPath;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelectionException;
import org.gradle.util.NameMatcher;

public class TaskSelector {
    private final TaskNameResolver taskNameResolver;
    private final GradleInternal gradle;
    private final ProjectFinderByTaskPath projectFinder = new ProjectFinderByTaskPath();

    public TaskSelector(GradleInternal gradle) {
        this(gradle, new TaskNameResolver());
    }

    public TaskSelector(GradleInternal gradle, TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
        this.gradle = gradle;
    }

    public TaskSelection getSelection(String path) {
        SetMultimap<String, Task> tasksByName;
        String prefix;
        String baseName;
        ProjectInternal project = this.gradle.getDefaultProject();
        if (path.contains(":")) {
            project = this.projectFinder.findProject(path, project);
            baseName = StringUtils.substringAfterLast((String)path, (String)":");
            prefix = project.getPath() + ":";
            tasksByName = this.taskNameResolver.select(baseName, project);
        } else {
            baseName = path;
            prefix = "";
            tasksByName = this.taskNameResolver.selectAll(path, project);
        }
        Set tasks = tasksByName.get((Object)baseName);
        if (!tasks.isEmpty()) {
            return new TaskSelection(path, tasks);
        }
        NameMatcher matcher = new NameMatcher();
        String actualName = matcher.find(baseName, tasksByName.keySet());
        if (actualName != null) {
            return new TaskSelection(prefix + actualName, tasksByName.get((Object)actualName));
        }
        throw new TaskSelectionException(matcher.formatErrorMessage("task", project));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskSelection {
        private String taskName;
        private Set<Task> tasks;

        public TaskSelection(String taskName, Set<Task> tasks) {
            this.taskName = taskName;
            this.tasks = tasks;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Set<Task> getTasks() {
            return this.tasks;
        }
    }
}

