/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolver {
    public SetMultimap<String, Task> select(String name, Project project) {
        return this.select(name, (ProjectInternal)project, Collections.<Project>emptySet());
    }

    public SetMultimap<String, Task> selectAll(String name, Project project) {
        return this.select(name, (ProjectInternal)project, project.getSubprojects());
    }

    private SetMultimap<String, Task> select(String name, ProjectInternal project, Iterable<Project> additionalProjects) {
        LinkedHashMultimap selected = LinkedHashMultimap.create();
        Task task = (Task)project.getTasks().findByName(name);
        if (task != null) {
            selected.put((Object)task.getName(), (Object)task);
        } else {
            task = (Task)project.getImplicitTasks().findByName(name);
            if (task != null) {
                selected.put((Object)task.getName(), (Object)task);
            }
        }
        for (Project additionalProject : additionalProjects) {
            task = (Task)additionalProject.getTasks().findByName(name);
            if (task == null) continue;
            selected.put((Object)task.getName(), (Object)task);
        }
        if (!selected.isEmpty()) {
            return selected;
        }
        for (Task t : project.getTasks()) {
            selected.put((Object)t.getName(), (Object)t);
        }
        for (Task t : project.getImplicitTasks()) {
            if (selected.containsKey((Object)t.getName())) continue;
            selected.put((Object)t.getName(), (Object)t);
        }
        for (Project additionalProject : additionalProjects) {
            for (Task t : additionalProject.getTasks()) {
                selected.put((Object)t.getName(), (Object)t);
            }
        }
        return selected;
    }
}

