/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.NameMatcher;

public class ProjectFinderByTaskPath {
    public ProjectInternal findProject(String taskPath, ProjectInternal startFrom) {
        if (!taskPath.contains(":")) {
            throw new IllegalArgumentException("I can only find tasks based on a task path (e.g. containing ':'). However, '" + taskPath + "' was passed.");
        }
        String projectPath = StringUtils.substringBeforeLast((String)taskPath, (String)":");
        projectPath = projectPath.length() == 0 ? ":" : projectPath;
        return ProjectFinderByTaskPath.findProjectNow(projectPath, startFrom);
    }

    private static ProjectInternal findProjectNow(String path, ProjectInternal startFrom) {
        if (path.equals(":")) {
            return startFrom.getRootProject();
        }
        Project current = startFrom;
        if (path.startsWith(":")) {
            current = current.getRootProject();
            path = path.substring(1);
        }
        String[] arr$ = path.split(":");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameMatcher matcher = new NameMatcher();
            String pattern = arr$[i$];
            Map<String, Project> children = current.getChildProjects();
            Project child = matcher.find(pattern, children);
            if (child == null) {
                throw new ProjectLookupException(matcher.formatErrorMessage("project", current));
            }
            current = child;
        }
        return current;
    }

    public static class ProjectLookupException
    extends InvalidUserDataException {
        public ProjectLookupException(String message) {
            super(message);
        }
    }
}

