/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.Cast;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.ivyservice.ModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

public class Upload
extends ConventionTask {
    private Configuration configuration;
    private boolean uploadDescriptor;
    private File descriptorDestination;
    private RepositoryHandler repositories;
    private final ArtifactPublicationServices publicationServices;

    @Inject
    public Upload(ArtifactPublicationServices publicationServices) {
        this.publicationServices = publicationServices;
        this.repositories = publicationServices.createRepositoryHandler();
    }

    @TaskAction
    protected void upload() {
        this.getLogger().info("Publishing configuration: " + this.configuration);
        Module module = ((ConfigurationInternal)this.configuration).getModule();
        Set<Configuration> configurationsToPublish = this.configuration.getHierarchy();
        ArtifactPublisher artifactPublisher = this.publicationServices.createArtifactPublisher();
        try {
            File descriptorDestination;
            File file = descriptorDestination = this.isUploadDescriptor() ? this.getDescriptorDestination() : null;
            if (descriptorDestination != null) {
                Set<Configuration> allConfigurations = configurationsToPublish.iterator().next().getAll();
                ModuleDescriptorConverter moduleDescriptorConverter = this.publicationServices.getDescriptorFileModuleConverter();
                ModuleDescriptor moduleDescriptor = moduleDescriptorConverter.convert(allConfigurations, module);
                IvyModuleDescriptorWriter ivyModuleDescriptorWriter = this.publicationServices.getIvyModuleDescriptorWriter();
                ivyModuleDescriptorWriter.write(moduleDescriptor, descriptorDestination);
            }
            List resolvers = CollectionUtils.collect((List)this.repositories, (Transformer)new Transformer<DependencyResolver, ArtifactRepository>(){

                public DependencyResolver transform(ArtifactRepository repository) {
                    return ((ArtifactRepositoryInternal)Cast.cast(ArtifactRepositoryInternal.class, (Object)repository)).createResolver();
                }
            });
            artifactPublisher.publish(resolvers, module, configurationsToPublish, descriptorDestination);
        }
        catch (Exception e) {
            throw new PublishException(String.format("Could not publish configuration '%s'", this.configuration.getName()), e);
        }
    }

    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public void setUploadDescriptor(boolean uploadDescriptor) {
        this.uploadDescriptor = uploadDescriptor;
    }

    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public void setDescriptorDestination(File descriptorDestination) {
        this.descriptorDestination = descriptorDestination;
    }

    public RepositoryHandler getRepositories() {
        return this.repositories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public RepositoryHandler repositories(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.repositories);
    }

    @InputFiles
    public FileCollection getArtifacts() {
        Configuration configuration = this.getConfiguration();
        return configuration == null ? null : configuration.getAllArtifacts().getFiles();
    }
}

