/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory
implements ITaskFactory {
    public static final String GENERATE_SUBCLASS = "generateSubclass";
    private final ClassGenerator generator;
    private final ProjectInternal project;
    private final Instantiator instantiator;

    public TaskFactory(ClassGenerator generator) {
        this(generator, null, null);
    }

    TaskFactory(ClassGenerator generator, ProjectInternal project, Instantiator instantiator) {
        this.generator = generator;
        this.project = project;
        this.instantiator = instantiator;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new TaskFactory(this.generator, project, instantiator);
    }

    @Override
    public TaskInternal createTask(Map<String, ?> args) {
        Object action;
        Object group;
        Object description;
        HashMap<String, Object> actualArgs = new HashMap<String, Object>(args);
        this.checkTaskArgsAndCreateDefaultValues(actualArgs);
        String name = actualArgs.get("name").toString();
        if (!GUtil.isTrue(name)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class type = (Class)actualArgs.get("type");
        Boolean generateSubclass = Boolean.valueOf(actualArgs.get(GENERATE_SUBCLASS).toString());
        TaskInternal task = this.createTaskObject(this.project, type, name, generateSubclass);
        Object dependsOnTasks = actualArgs.get("dependsOn");
        if (dependsOnTasks != null) {
            task.dependsOn(dependsOnTasks);
        }
        if ((description = actualArgs.get("description")) != null) {
            task.setDescription(description.toString());
        }
        if ((group = actualArgs.get("group")) != null) {
            task.setGroup(group.toString());
        }
        if ((action = actualArgs.get("action")) instanceof Action) {
            Action taskAction = (Action)action;
            task.doFirst((Action<? super Task>)taskAction);
        } else if (action != null) {
            Closure closure = (Closure)action;
            task.doFirst(closure);
        }
        return task;
    }

    private TaskInternal createTaskObject(ProjectInternal project, final Class<? extends TaskInternal> type, String name, boolean generateGetters) {
        if (!Task.class.isAssignableFrom(type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", type.getSimpleName()));
        }
        final Class<? extends TaskInternal> generatedType = generateGetters ? this.generator.generate(type) : type;
        return AbstractTask.injectIntoNewInstance(project, name, new Callable<TaskInternal>(){

            @Override
            public TaskInternal call() throws Exception {
                try {
                    return (TaskInternal)TaskFactory.this.instantiator.newInstance(generatedType, new Object[0]);
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", type.getSimpleName()), e.getCause());
                }
            }
        });
    }

    private void checkTaskArgsAndCreateDefaultValues(Map<String, Object> args) {
        this.setIfNull(args, "name", "");
        this.setIfNull(args, "type", DefaultTask.class);
        if (((Class)args.get("type")).isAssignableFrom(DefaultTask.class)) {
            args.put("type", DefaultTask.class);
        }
        this.setIfNull(args, GENERATE_SUBCLASS, "true");
    }

    private void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }
}

