/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;

public class OutputFilesChangedUpToDateRule
implements UpToDateRule {
    private final FileSnapshotter outputFilesSnapshotter;

    public OutputFilesChangedUpToDateRule(FileSnapshotter outputFilesSnapshotter) {
        this.outputFilesSnapshotter = outputFilesSnapshotter;
    }

    public UpToDateRule.TaskUpToDateState create(final TaskInternal task, final TaskExecution previousExecution, final TaskExecution currentExecution) {
        final FileCollectionSnapshot outputFilesBefore = this.outputFilesSnapshotter.snapshot(task.getOutputs().getFiles());
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> messages) {
                if (previousExecution.getOutputFilesSnapshot() == null) {
                    messages.add(String.format("Output file history is not available for %s.", task));
                    return;
                }
                outputFilesBefore.changesSince(previousExecution.getOutputFilesSnapshot(), new ChangeListener<File>(){

                    @Override
                    public void added(File element) {
                        messages.add(String.format("Output file '%s' has been added for %s.", element, task));
                    }

                    @Override
                    public void removed(File element) {
                        messages.add(String.format("Output file %s has been removed for %s.", element.getAbsolutePath(), task));
                    }

                    @Override
                    public void changed(File element) {
                        messages.add(String.format("Output file %s for %s has changed.", element.getAbsolutePath(), task));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
                FileCollectionSnapshot lastExecutionOutputFiles = previousExecution == null || previousExecution.getOutputFilesSnapshot() == null ? OutputFilesChangedUpToDateRule.this.outputFilesSnapshotter.emptySnapshot() : previousExecution.getOutputFilesSnapshot();
                FileCollectionSnapshot newOutputFiles = outputFilesBefore.changesSince(lastExecutionOutputFiles).applyTo(lastExecutionOutputFiles, new ChangeListener<FileCollectionSnapshot.Merge>(){

                    @Override
                    public void added(FileCollectionSnapshot.Merge element) {
                        element.ignore();
                    }

                    @Override
                    public void removed(FileCollectionSnapshot.Merge element) {
                    }

                    @Override
                    public void changed(FileCollectionSnapshot.Merge element) {
                    }
                });
                FileCollectionSnapshot outputFilesAfter = OutputFilesChangedUpToDateRule.this.outputFilesSnapshotter.snapshot(task.getOutputs().getFiles());
                currentExecution.setOutputFilesSnapshot(outputFilesAfter.changesSince(outputFilesBefore).applyTo(newOutputFiles));
            }
        };
    }
}

