/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

public class InputPropertiesChangedUpToDateRule
implements UpToDateRule {
    public UpToDateRule.TaskUpToDateState create(final TaskInternal task, final TaskExecution previousExecution, TaskExecution currentExecution) {
        final HashMap<String, Object> properties = new HashMap<String, Object>(task.getInputs().getProperties());
        currentExecution.setInputProperties(properties);
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> messages) {
                DiffUtil.diff(properties, previousExecution.getInputProperties(), new ChangeListener<Map.Entry<String, Object>>(){

                    @Override
                    public void added(Map.Entry<String, Object> element) {
                        messages.add(String.format("Input property '%s' has been added for %s", element.getKey(), task));
                    }

                    @Override
                    public void removed(Map.Entry<String, Object> element) {
                        messages.add(String.format("Input property '%s' has been removed for %s", element.getKey(), task));
                    }

                    @Override
                    public void changed(Map.Entry<String, Object> element) {
                        messages.add(String.format("Value of input property '%s' has changed for %s", element.getKey(), task));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
            }
        };
    }
}

