/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;

public class CompositeUpToDateRule
implements UpToDateRule {
    private final List<UpToDateRule> rules;

    public CompositeUpToDateRule(UpToDateRule ... rules) {
        this.rules = new ArrayList<UpToDateRule>(Arrays.asList(rules));
    }

    public UpToDateRule.TaskUpToDateState create(TaskInternal task, TaskExecution previousExecution, TaskExecution currentExecution) {
        final ArrayList<UpToDateRule.TaskUpToDateState> states = new ArrayList<UpToDateRule.TaskUpToDateState>();
        for (UpToDateRule rule : this.rules) {
            states.add(rule.create(task, previousExecution, currentExecution));
        }
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(Collection<String> messages) {
                for (int i = 0; messages.isEmpty() && i < states.size(); ++i) {
                    UpToDateRule.TaskUpToDateState state = (UpToDateRule.TaskUpToDateState)states.get(i);
                    state.checkUpToDate(messages);
                }
            }

            @Override
            public void snapshotAfterTask() {
                for (UpToDateRule.TaskUpToDateState state : states) {
                    state.snapshotAfterTask();
                }
            }
        };
    }
}

