/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConfigureByMapAction;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.api.internal.artifacts.configurations.ResolverProvider;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandler,
ResolverProvider {
    public static final String FLAT_DIR_DEFAULT_NAME = "flatDir";
    private static final String MAVEN_REPO_DEFAULT_NAME = "maven";
    private static final String IVY_REPO_DEFAULT_NAME = "ivy";
    private final BaseRepositoryFactory repositoryFactory;

    public DefaultRepositoryHandler(BaseRepositoryFactory repositoryFactory, Instantiator instantiator) {
        super(repositoryFactory, instantiator);
        this.repositoryFactory = repositoryFactory;
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createFlatDirRepository(), FLAT_DIR_DEFAULT_NAME, action);
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Closure configureClosure) {
        return this.flatDir(new ClosureBackedAction(configureClosure));
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("dirs")) {
            modifiedArgs.put("dirs", CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.get("dirs")}));
        }
        return this.flatDir(new ConfigureByMapAction(modifiedArgs));
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo");
    }

    @Override
    public MavenArtifactRepository mavenCentral(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls")) {
            DeprecationLogger.nagUserOfDeprecated("The 'urls' property of the RepositoryHandler.mavenCentral() method", "You should use the 'artifactUrls' property to define additional artifact locations");
            List urls = CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.remove("urls")});
            modifiedArgs.put("artifactUrls", urls);
        }
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo", new ConfigureByMapAction(modifiedArgs));
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.repositoryFactory.createMavenLocalRepository(), "MavenLocal");
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args) {
        return this.mavenRepo(args, null);
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args, Closure configClosure) {
        List urls;
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls") && !(urls = CollectionUtils.flattenToList((Object[])new Object[]{modifiedArgs.remove("urls")})).isEmpty()) {
            DeprecationLogger.nagUserOfDeprecated("The 'urls' property of the RepositoryHandler.mavenRepo() method", "You should use the 'url' property to define the core maven repository & the 'artifactUrls' property to define any additional artifact locations");
            modifiedArgs.put("url", urls.get(0));
            List extraUrls = urls.subList(1, urls.size());
            modifiedArgs.put("artifactUrls", extraUrls);
        }
        MavenArtifactRepository repository = this.repositoryFactory.createMavenRepository();
        ConfigureUtil.configureByMap(modifiedArgs, repository);
        DependencyResolver resolver = this.repositoryFactory.toResolver(repository);
        ConfigureUtil.configure(configClosure, resolver);
        this.addRepository(new FixedResolverArtifactRepository(resolver), "mavenRepo");
        return resolver;
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createMavenRepository(), MAVEN_REPO_DEFAULT_NAME, action);
    }

    @Override
    public MavenArtifactRepository maven(Closure closure) {
        return this.maven(new ClosureBackedAction(closure));
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createIvyRepository(), IVY_REPO_DEFAULT_NAME, action);
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        return this.ivy(new ClosureBackedAction(closure));
    }
}

