/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.List;
import org.gradle.internal.nativeplatform.console.ConsoleMetaData;
import org.gradle.logging.internal.ConsoleBackedProgressRenderer;
import org.gradle.logging.internal.StatusBarFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStatusBarFormatter
implements StatusBarFormatter {
    private final ConsoleMetaData consoleMetaData;

    public DefaultStatusBarFormatter(ConsoleMetaData consoleMetaData) {
        this.consoleMetaData = consoleMetaData;
    }

    @Override
    public String format(List<ConsoleBackedProgressRenderer.Operation> operations) {
        StringBuilder builder = new StringBuilder();
        for (ConsoleBackedProgressRenderer.Operation operation : operations) {
            String message = operation.getMessage();
            if (message == null) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("> ");
            builder.append(message);
        }
        return this.trim(builder);
    }

    private String trim(StringBuilder formattedString) {
        int width = this.consoleMetaData.getCols() - 1;
        if (width > 0 && width < formattedString.length()) {
            return formattedString.substring(0, width);
        }
        return formattedString.toString();
    }
}

