/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelectionException;
import org.gradle.util.NameMatcher;

public class TaskSelector {
    private final TaskNameResolver taskNameResolver;
    private final GradleInternal gradle;

    public TaskSelector(GradleInternal gradle) {
        this(gradle, new TaskNameResolver());
    }

    public TaskSelector(GradleInternal gradle, TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
        this.gradle = gradle;
    }

    public TaskSelection getSelection(String path) {
        SetMultimap<String, Task> tasksByName;
        String prefix;
        String baseName;
        ProjectInternal project = this.gradle.getDefaultProject();
        if (path.contains(":")) {
            String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
            projectPath = projectPath.length() == 0 ? ":" : projectPath;
            project = TaskSelector.findProject(project, projectPath);
            baseName = StringUtils.substringAfterLast((String)path, (String)":");
            prefix = project.getPath() + ":";
            tasksByName = this.taskNameResolver.select(baseName, project);
        } else {
            baseName = path;
            prefix = "";
            tasksByName = this.taskNameResolver.selectAll(path, project);
        }
        Set tasks = tasksByName.get((Object)baseName);
        if (!tasks.isEmpty()) {
            return new TaskSelection(path, tasks);
        }
        NameMatcher matcher = new NameMatcher();
        String actualName = matcher.find(baseName, tasksByName.keySet());
        if (actualName != null) {
            return new TaskSelection(prefix + actualName, tasksByName.get((Object)actualName));
        }
        throw new TaskSelectionException(matcher.formatErrorMessage("task", project));
    }

    private static ProjectInternal findProject(ProjectInternal startFrom, String path) {
        if (path.equals(":")) {
            return startFrom.getRootProject();
        }
        Project current = startFrom;
        if (path.startsWith(":")) {
            current = current.getRootProject();
            path = path.substring(1);
        }
        String[] arr$ = path.split(":");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameMatcher matcher = new NameMatcher();
            String pattern = arr$[i$];
            Map<String, Project> children = current.getChildProjects();
            Project child = matcher.find(pattern, children);
            if (child == null) {
                throw new TaskSelectionException(matcher.formatErrorMessage("project", current));
            }
            current = child;
        }
        return current;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskSelection {
        private String taskName;
        private Set<Task> tasks;

        public TaskSelection(String taskName, Set<Task> tasks) {
            this.taskName = taskName;
            this.tasks = tasks;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Set<Task> getTasks() {
            return this.tasks;
        }
    }
}

