/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.api.Action;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.RelativePathSpec;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.internal.PatternSetAntBuilderDelegate;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet
implements AntBuilderAware,
PatternFilterable {
    private Set<String> includes = new LinkedHashSet<String>();
    private Set<String> excludes = new LinkedHashSet<String>();
    private Set<Spec<FileTreeElement>> includeSpecs = new LinkedHashSet<Spec<FileTreeElement>>();
    private Set<Spec<FileTreeElement>> excludeSpecs = new LinkedHashSet<Spec<FileTreeElement>>();
    boolean caseSensitive = true;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternSet that = (PatternSet)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (!this.excludes.equals(that.excludes)) {
            return false;
        }
        return this.includes.equals(that.includes);
    }

    public int hashCode() {
        int result = this.includes.hashCode();
        result = 31 * result + this.excludes.hashCode();
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        return result;
    }

    public PatternSet copyFrom(PatternFilterable sourcePattern) {
        this.setIncludes(sourcePattern.getIncludes());
        this.setExcludes(sourcePattern.getExcludes());
        PatternSet other = (PatternSet)sourcePattern;
        this.includeSpecs.clear();
        this.includeSpecs.addAll(other.includeSpecs);
        this.excludeSpecs.clear();
        this.excludeSpecs.addAll(other.excludeSpecs);
        return this;
    }

    public PatternSet intersect() {
        return new IntersectionPatternSet(this);
    }

    public Spec<FileTreeElement> getAsSpec() {
        boolean hasIncludes;
        OrSpec includeSpec = Specs.satisfyAll();
        Set<String> includes = this.getIncludes();
        Set<Spec<FileTreeElement>> includeSpecs = this.getIncludeSpecs();
        boolean bl = hasIncludes = !includes.isEmpty() || !includeSpecs.isEmpty();
        if (hasIncludes) {
            LinkedList<Spec<FileTreeElement>> matchers = new LinkedList<Spec<FileTreeElement>>();
            for (String include : includes) {
                Spec<RelativePath> patternMatcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), include);
                matchers.add(new RelativePathSpec(patternMatcher));
            }
            matchers.addAll(includeSpecs);
            includeSpec = new OrSpec(matchers);
        }
        Set<String> excludes = this.getExcludes();
        HashSet<String> allExcludes = new HashSet<String>(excludes);
        Collections.addAll(allExcludes, DirectoryScanner.getDefaultExcludes());
        Set<Spec<FileTreeElement>> excludeSpecs = this.getExcludeSpecs();
        LinkedList<Spec<FileTreeElement>> matchers = new LinkedList<Spec<FileTreeElement>>();
        for (String exclude : allExcludes) {
            Spec<RelativePath> patternMatcher = PatternMatcherFactory.getPatternMatcher(false, this.isCaseSensitive(), exclude);
            matchers.add(new RelativePathSpec(patternMatcher));
        }
        matchers.addAll(excludeSpecs);
        NotSpec excludeSpec = new NotSpec((Spec)new OrSpec(matchers));
        if (!hasIncludes) {
            return excludeSpec;
        }
        return new AndSpec(new Spec[]{includeSpec, excludeSpec});
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<Spec<FileTreeElement>> getIncludeSpecs() {
        return this.includeSpecs;
    }

    @Override
    public PatternSet setIncludes(Iterable<String> includes) {
        this.includes.clear();
        return this.include((Iterable)includes);
    }

    @Override
    public PatternSet include(String ... includes) {
        return this.include(Arrays.asList(includes));
    }

    @Override
    public PatternSet include(Iterable<String> includes) {
        CollectionUtils.addAll(this.includes, includes);
        return this;
    }

    @Override
    public PatternSet include(Spec<FileTreeElement> spec) {
        this.includeSpecs.add(spec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Set<Spec<FileTreeElement>> getExcludeSpecs() {
        return this.excludeSpecs;
    }

    @Override
    public PatternSet setExcludes(Iterable<String> excludes) {
        this.excludes.clear();
        return this.exclude((Iterable)excludes);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public PatternSet includeSpecs(Iterable<Spec<FileTreeElement>> includeSpecs) {
        CollectionUtils.addAll(this.includeSpecs, includeSpecs);
        return this;
    }

    @Override
    public PatternSet include(Closure closure) {
        this.include(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public PatternSet exclude(String ... excludes) {
        Collections.addAll(this.excludes, excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Iterable<String> excludes) {
        CollectionUtils.addAll(this.excludes, excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Spec<FileTreeElement> spec) {
        this.excludeSpecs.add(spec);
        return this;
    }

    public PatternSet excludeSpecs(Iterable<Spec<FileTreeElement>> excludes) {
        CollectionUtils.addAll(this.excludeSpecs, excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Closure closure) {
        this.exclude(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        if (!this.getIncludeSpecs().isEmpty() || !this.getExcludeSpecs().isEmpty()) {
            throw new UnsupportedOperationException("Cannot add include/exclude specs to Ant node. Only include/exclude patterns are currently supported.");
        }
        return new PatternSetAntBuilderDelegate(this.getIncludes(), this.getExcludes(), this.isCaseSensitive()).addToAntBuilder(node, childNodeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectionPatternSet
    extends PatternSet {
        private final PatternSet other;

        public IntersectionPatternSet(PatternSet other) {
            this.other = other;
        }

        @Override
        public Spec<FileTreeElement> getAsSpec() {
            return new AndSpec(new Spec[]{super.getAsSpec(), this.other.getAsSpec()});
        }

        @Override
        public Object addToAntBuilder(Object node, String childNodeName) {
            return PatternSetAntBuilderDelegate.and(node, new Action<Object>(){

                public void execute(Object andNode) {
                    IntersectionPatternSet.super.addToAntBuilder(andNode, null);
                    IntersectionPatternSet.this.other.addToAntBuilder(andNode, null);
                }
            });
        }
    }
}

