/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends ConventionTask {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private Configuration configuration;
    private boolean uploadDescriptor;
    private File descriptorDestination;
    private RepositoryHandler repositories;
    private ArtifactPublisher artifactPublisher;

    public Upload() {
        ArtifactPublicationServices publicationServices = (ArtifactPublicationServices)this.getServices().getFactory(ArtifactPublicationServices.class).create();
        this.repositories = publicationServices.getRepositoryHandler();
        this.artifactPublisher = publicationServices.getArtifactPublisher();
    }

    @TaskAction
    protected void upload() {
        logger.info("Publishing configuration: " + this.configuration);
        ConfigurationInternal configurationInternal = (ConfigurationInternal)this.configuration;
        this.artifactPublisher.publish(configurationInternal.getModule(), this.configuration.getHierarchy(), this.isUploadDescriptor() ? this.getDescriptorDestination() : null, null);
    }

    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public void setUploadDescriptor(boolean uploadDescriptor) {
        this.uploadDescriptor = uploadDescriptor;
    }

    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public void setDescriptorDestination(File descriptorDestination) {
        this.descriptorDestination = descriptorDestination;
    }

    public RepositoryHandler getRepositories() {
        return this.repositories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public RepositoryHandler repositories(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.repositories);
    }

    @InputFiles
    public FileCollection getArtifacts() {
        Configuration configuration = this.getConfiguration();
        return configuration == null ? null : configuration.getAllArtifacts().getFiles();
    }

    void setRepositories(RepositoryHandler repositories) {
        this.repositories = repositories;
    }

    void setArtifactPublisher(ArtifactPublisher artifactPublisher) {
        this.artifactPublisher = artifactPublisher;
    }
}

