/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.Collection;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedNotationParser<N, T>
implements NotationParser<T> {
    private final Class<N> typeToken;

    public TypedNotationParser(Class<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add(String.format("Instances of %s.", this.typeToken.getSimpleName()));
    }

    @Override
    public T parseNotation(Object notation) {
        if (!this.typeToken.isInstance(notation)) {
            throw new UnsupportedNotationException(notation);
        }
        return this.parseType(this.typeToken.cast(notation));
    }

    protected abstract T parseType(N var1);
}

