/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileOrUriNotationParser;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileResource;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.resources.ReadableResource;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileResolver
implements FileResolver {
    private final FileSystem fileSystem;
    private FileOrUriNotationParser fileNotationParser;

    protected AbstractFileResolver(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.fileNotationParser = new FileOrUriNotationParser(fileSystem);
    }

    @Override
    public FileResolver withBaseDir(Object path) {
        return new BaseDirFileResolver(this.fileSystem, this.resolve(path));
    }

    @Override
    public File resolve(Object path) {
        return this.resolve(path, PathValidation.NONE);
    }

    @Override
    public File resolve(Object path, PathValidation validation) {
        File file = this.doResolve(path);
        file = this.normalise(file);
        this.validate(file, validation);
        return file;
    }

    private File normalise(File file) {
        try {
            assert (file.isAbsolute()) : String.format("Cannot normalize a relative file: '%s'", file);
            if (OperatingSystem.current().isWindows()) {
                return file.getCanonicalFile();
            }
            String[] segments = file.getPath().split(String.format("[/%s]", Pattern.quote(File.separator)));
            ArrayList<String> path = new ArrayList<String>(segments.length);
            for (String segment : segments) {
                if (segment.equals("..")) {
                    if (path.isEmpty()) continue;
                    path.remove(path.size() - 1);
                    continue;
                }
                if (segment.equals(".") || segment.length() <= 0) continue;
                path.add(segment);
            }
            String resolvedPath = CollectionUtils.join((String)File.separator, path);
            boolean needLeadingSeparator = File.listRoots()[0].getPath().startsWith(File.separator);
            if (needLeadingSeparator) {
                resolvedPath = File.separator + resolvedPath;
            }
            File candidate = new File(resolvedPath);
            if (this.fileSystem.isCaseSensitive()) {
                return candidate;
            }
            File canonical = candidate.getCanonicalFile();
            if (candidate.getPath().equalsIgnoreCase(canonical.getPath())) {
                return canonical;
            }
            File current = File.listRoots()[0];
            for (int pos = 0; pos < path.size(); ++pos) {
                File child = this.findChild(current, (String)path.get(pos));
                if (child == null) {
                    current = new File(current, CollectionUtils.join((String)File.separator, path.subList(pos, path.size())));
                    break;
                }
                current = child;
            }
            return current;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not normalize path for file '%s'.", file), (Throwable)e);
        }
    }

    private File findChild(File current, String segment) throws IOException {
        String[] children = current.list();
        if (children == null) {
            return null;
        }
        for (String child : children) {
            if (!child.equalsIgnoreCase(segment)) continue;
            return new File(current, child);
        }
        return new File(current, segment);
    }

    @Override
    public Factory<File> resolveLater(final Object path) {
        return new Factory<File>(){

            public File create() {
                return AbstractFileResolver.this.resolve(path);
            }
        };
    }

    @Override
    public URI resolveUri(Object path) {
        return this.convertObjectToURI(path);
    }

    protected abstract File doResolve(Object var1);

    protected URI convertObjectToURI(Object path) {
        Object object = this.unpack(path);
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return this.resolve(converted).toURI();
        }
        return (URI)converted;
    }

    protected File convertObjectToFile(Object path) {
        Object object = this.unpack(path);
        if (object == null) {
            return null;
        }
        Object converted = this.fileNotationParser.parseNotation(object);
        if (converted instanceof File) {
            return (File)converted;
        }
        throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", converted));
    }

    private Object unpack(Object path) {
        Object current = path;
        while (current != null) {
            if (current instanceof Closure) {
                current = ((Closure)current).call();
                continue;
            }
            if (current instanceof Callable) {
                try {
                    current = ((Callable)current).call();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (current instanceof Factory) {
                return ((Factory)current).create();
            }
            return current;
        }
        return null;
    }

    protected void validate(File file, PathValidation validation) {
        switch (validation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }

    @Override
    public FileCollection resolveFiles(Object ... paths) {
        if (paths.length == 1 && paths[0] instanceof FileCollection) {
            return (FileCollection)paths[0];
        }
        return new DefaultConfigurableFileCollection(this, null, paths);
    }

    @Override
    public FileTree resolveFilesAsTree(Object ... paths) {
        return this.resolveFiles(paths).getAsFileTree();
    }

    @Override
    public ReadableResource resolveResource(Object path) {
        if (path instanceof ReadableResource) {
            return (ReadableResource)path;
        }
        return new FileResource(this.resolve(path));
    }
}

