/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.MapMergeChangeListener;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.id.IdGenerator;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;
import org.gradle.util.NoOpChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesSnapshotter
implements FileSnapshotter {
    private final FileSnapshotter snapshotter;
    private final IdGenerator<Long> idGenerator;
    private final PersistentIndexedCache<String, Long> dirIdentiferCache;

    public OutputFilesSnapshotter(FileSnapshotter snapshotter, IdGenerator<Long> idGenerator, TaskArtifactStateCacheAccess cacheAccess) {
        this.snapshotter = snapshotter;
        this.idGenerator = idGenerator;
        this.dirIdentiferCache = cacheAccess.createCache("outputFileStates", String.class, Long.class);
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesSnapshot(new HashMap<String, Long>(), this.snapshotter.emptySnapshot());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection files) {
        HashMap<String, Long> snapshotDirIds = new HashMap<String, Long>();
        for (File file : files) {
            Long dirId;
            if (file.exists()) {
                dirId = this.dirIdentiferCache.get(file.getAbsolutePath());
                if (dirId == null) {
                    dirId = (Long)this.idGenerator.generateId();
                    this.dirIdentiferCache.put(file.getAbsolutePath(), dirId);
                }
            } else {
                this.dirIdentiferCache.remove(file.getAbsolutePath());
                dirId = null;
            }
            snapshotDirIds.put(file.getAbsolutePath(), dirId);
        }
        return new OutputFilesSnapshot(snapshotDirIds, this.snapshotter.snapshot(files));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFilesDiff
    implements FileCollectionSnapshot.Diff {
        private final Map<String, Long> newFileIds;
        private final Map<String, Long> oldFileIds;
        private final FileCollectionSnapshot.Diff filesDiff;

        public OutputFilesDiff(Map<String, Long> newFileIds, Map<String, Long> oldFileIds, FileCollectionSnapshot.Diff filesDiff) {
            this.newFileIds = newFileIds;
            this.oldFileIds = oldFileIds;
            this.filesDiff = filesDiff;
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot, ChangeListener<FileCollectionSnapshot.Merge> listener) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)snapshot;
            HashMap dirIds = new HashMap(other.rootFileIds);
            DiffUtil.diff(this.newFileIds, this.oldFileIds, new MapMergeChangeListener(new NoOpChangeListener<FileCollectionSnapshot.Merge>(), dirIds));
            return new OutputFilesSnapshot(this.newFileIds, this.filesDiff.applyTo(other.filesSnapshot, listener));
        }

        @Override
        public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot) {
            return this.applyTo(snapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputFilesSnapshot
    implements FileCollectionSnapshot {
        private final Map<String, Long> rootFileIds;
        private final FileCollectionSnapshot filesSnapshot;

        public OutputFilesSnapshot(Map<String, Long> rootFileIds, FileCollectionSnapshot filesSnapshot) {
            this.rootFileIds = rootFileIds;
            this.filesSnapshot = filesSnapshot;
        }

        @Override
        public FileCollection getFiles() {
            return this.filesSnapshot.getFiles();
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot oldSnapshot) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            return new OutputFilesDiff(this.rootFileIds, other.rootFileIds, this.filesSnapshot.changesSince(other.filesSnapshot));
        }

        @Override
        public void changesSince(FileCollectionSnapshot oldSnapshot, final ChangeListener<File> listener) {
            final OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            DiffUtil.diff(this.rootFileIds, other.rootFileIds, new ChangeListener<Map.Entry<String, Long>>(){

                @Override
                public void added(Map.Entry<String, Long> element) {
                    listener.added(new File(element.getKey()));
                }

                @Override
                public void removed(Map.Entry<String, Long> element) {
                    listener.removed(new File(element.getKey()));
                }

                @Override
                public void changed(Map.Entry<String, Long> element) {
                    if (other.rootFileIds.get(element.getKey()) == null) {
                        return;
                    }
                    listener.changed(new File(element.getKey()));
                }
            });
            this.filesSnapshot.changesSince(other.filesSnapshot, new ChangeListener<File>(){

                @Override
                public void added(File element) {
                }

                @Override
                public void removed(File element) {
                    listener.removed(element);
                }

                @Override
                public void changed(File element) {
                    listener.changed(element);
                }
            });
        }
    }
}

