/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    Map<Object, byte[]> entries = new HashMap<Object, byte[]>();

    @Override
    public V get(K key) {
        byte[] serialised = this.entries.get(key);
        if (serialised == null) {
            return null;
        }
        try {
            ByteArrayInputStream instr = new ByteArrayInputStream(serialised);
            return (V)new ObjectInputStream(instr).readObject();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void put(K key, V value) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objstr = new ObjectOutputStream(outstr);
            objstr.writeObject(value);
            objstr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        this.entries.put(key, outstr.toByteArray());
    }

    @Override
    public void remove(K key) {
        this.entries.remove(key);
    }
}

