/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.TaskHistoryRepository;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskHistory> taskHistoryCache;
    private final DefaultSerializer<TaskHistory> serializer = new DefaultSerializer();

    public CacheBackedTaskHistoryRepository(TaskArtifactStateCacheAccess cacheAccess, FileSnapshotRepository snapshotRepository) {
        this.cacheAccess = cacheAccess;
        this.snapshotRepository = snapshotRepository;
        this.taskHistoryCache = cacheAccess.createCache("taskArtifacts", String.class, TaskHistory.class, this.serializer);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final TaskHistory history = this.loadHistory(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution();
        currentExecution.snapshotRepository = this.snapshotRepository;
        currentExecution.cacheAccess = this.cacheAccess;
        currentExecution.setOutputFiles(CacheBackedTaskHistoryRepository.outputFiles(task));
        final LazyTaskExecution previousExecution = this.findPreviousExecution(currentExecution, history);
        if (previousExecution != null) {
            previousExecution.snapshotRepository = this.snapshotRepository;
            previousExecution.cacheAccess = this.cacheAccess;
        }
        history.configurations.add(0, currentExecution);
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                if (currentExecution.inputFilesSnapshotId == null && currentExecution.inputFilesSnapshot != null) {
                    currentExecution.inputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.inputFilesSnapshot);
                }
                if (currentExecution.outputFilesSnapshotId == null && currentExecution.outputFilesSnapshot != null) {
                    currentExecution.outputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.outputFilesSnapshot);
                }
                while (history.configurations.size() > 3) {
                    LazyTaskExecution execution = (LazyTaskExecution)history.configurations.remove(history.configurations.size() - 1);
                    if (execution.inputFilesSnapshotId != null) {
                        CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.inputFilesSnapshotId);
                    }
                    if (execution.outputFilesSnapshotId == null) continue;
                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.outputFilesSnapshotId);
                }
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), history);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskHistory loadHistory(TaskInternal task) {
        ClassLoader original = this.serializer.getClassLoader();
        this.serializer.setClassLoader(task.getClass().getClassLoader());
        try {
            TaskHistory history = this.taskHistoryCache.get(task.getPath());
            TaskHistory taskHistory = history == null ? new TaskHistory() : history;
            return taskHistory;
        }
        finally {
            this.serializer.setClassLoader(original);
        }
    }

    private static Set<String> outputFiles(TaskInternal task) {
        HashSet<String> outputFiles = new HashSet<String>();
        for (File file : task.getOutputs().getFiles()) {
            outputFiles.add(file.getAbsolutePath());
        }
        return outputFiles;
    }

    private LazyTaskExecution findPreviousExecution(TaskExecution currentExecution, TaskHistory history) {
        Set<String> outputFiles = currentExecution.getOutputFiles();
        LazyTaskExecution bestMatch = null;
        int bestMatchOverlap = 0;
        for (LazyTaskExecution configuration : history.configurations) {
            if (outputFiles.size() == 0 && configuration.getOutputFiles().size() == 0) {
                bestMatch = configuration;
                break;
            }
            HashSet<String> intersection = new HashSet<String>(outputFiles);
            intersection.retainAll(configuration.getOutputFiles());
            if (intersection.size() > bestMatchOverlap) {
                bestMatch = configuration;
                bestMatchOverlap = intersection.size();
            }
            if (bestMatchOverlap != outputFiles.size()) continue;
            break;
        }
        return bestMatch;
    }

    private static class LazyTaskExecution
    extends TaskExecution {
        private Long inputFilesSnapshotId;
        private Long outputFilesSnapshotId;
        private transient FileSnapshotRepository snapshotRepository;
        private transient FileCollectionSnapshot inputFilesSnapshot;
        private transient FileCollectionSnapshot outputFilesSnapshot;
        private transient TaskArtifactStateCacheAccess cacheAccess;

        private LazyTaskExecution() {
        }

        public FileCollectionSnapshot getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                this.inputFilesSnapshot = this.snapshotRepository.get(this.inputFilesSnapshotId);
            }
            return this.inputFilesSnapshot;
        }

        public void setInputFilesSnapshot(FileCollectionSnapshot inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotId = null;
        }

        public FileCollectionSnapshot getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                this.outputFilesSnapshot = this.cacheAccess.useCache("fetch output files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.outputFilesSnapshotId);
                    }
                });
            }
            return this.outputFilesSnapshot;
        }

        public void setOutputFilesSnapshot(FileCollectionSnapshot outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotId = null;
        }
    }

    private static class TaskHistory
    implements Serializable {
        private static final int MAX_HISTORY_ENTRIES = 3;
        private final List<LazyTaskExecution> configurations = new ArrayList<LazyTaskExecution>();

        private TaskHistory() {
        }
    }
}

