/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ArtifactRepositoryContainer;
import org.gradle.api.artifacts.UnknownRepositoryException;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.Cast;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactRepositoryContainer
extends DefaultNamedDomainObjectList<ArtifactRepository>
implements ArtifactRepositoryContainer {
    private final BaseRepositoryFactory baseRepositoryFactory;
    private final Action<ArtifactRepository> addLastAction = new Action<ArtifactRepository>(){

        public void execute(ArtifactRepository repository) {
            DefaultArtifactRepositoryContainer.super.add(repository);
        }
    };
    private final Action<ArtifactRepository> addFirstAction = new Action<ArtifactRepository>(){

        public void execute(ArtifactRepository repository) {
            DefaultArtifactRepositoryContainer.super.add(0, repository);
        }
    };

    public DefaultArtifactRepositoryContainer(BaseRepositoryFactory baseRepositoryFactory, Instantiator instantiator) {
        super(ArtifactRepository.class, instantiator, new RepositoryNamer());
        this.baseRepositoryFactory = baseRepositoryFactory;
    }

    @Override
    public String getTypeDisplayName() {
        return "repository";
    }

    @Override
    public DefaultArtifactRepositoryContainer configure(Closure closure) {
        return ConfigureUtil.configure(closure, this, false);
    }

    @Override
    public void addFirst(ArtifactRepository repository) {
        this.add(0, repository);
    }

    @Override
    public void addLast(ArtifactRepository repository) {
        this.add(repository);
    }

    @Override
    public boolean add(DependencyResolver resolver, Closure configureClosure) {
        this.addCustomDependencyResolver(resolver, configureClosure, this.addLastAction);
        return true;
    }

    @Override
    public boolean add(DependencyResolver resolver) {
        this.addCustomDependencyResolver(resolver, null, this.addLastAction);
        return true;
    }

    @Override
    public DependencyResolver addFirst(Object userDescription) {
        return this.addFirst(userDescription, null);
    }

    @Override
    public DependencyResolver addFirst(Object userDescription, Closure configureClosure) {
        return this.addCustomDependencyResolver(userDescription, configureClosure, this.addFirstAction);
    }

    @Override
    @Deprecated
    public DependencyResolver addLast(Object userDescription) {
        DeprecationLogger.nagUserOfReplacedMethod("ArtifactRepositoryContainer.addLast()", "maven() or add()");
        return this.addCustomDependencyResolver(userDescription, null, this.addLastAction);
    }

    @Override
    @Deprecated
    public DependencyResolver addLast(Object userDescription, Closure configureClosure) {
        DeprecationLogger.nagUserOfReplacedMethod("ArtifactRepositoryContainer.addLast()", "maven() or add()");
        return this.addCustomDependencyResolver(userDescription, configureClosure, this.addLastAction);
    }

    @Override
    public DependencyResolver addBefore(Object userDescription, String afterResolverName) {
        return this.addBefore(userDescription, afterResolverName, null);
    }

    @Override
    public DependencyResolver addBefore(Object userDescription, String afterResolverName, Closure configureClosure) {
        if (!GUtil.isTrue(afterResolverName)) {
            throw new InvalidUserDataException("You must specify afterResolverName");
        }
        final ArtifactRepository after = (ArtifactRepository)this.getByName(afterResolverName);
        return this.addCustomDependencyResolver(userDescription, configureClosure, new Action<ArtifactRepository>(){

            public void execute(ArtifactRepository repository) {
                DefaultArtifactRepositoryContainer.super.add(DefaultArtifactRepositoryContainer.this.indexOf(after), repository);
            }
        });
    }

    @Override
    public DependencyResolver addAfter(Object userDescription, String beforeResolverName) {
        return this.addAfter(userDescription, beforeResolverName, null);
    }

    @Override
    public DependencyResolver addAfter(Object userDescription, String beforeResolverName, Closure configureClosure) {
        if (!GUtil.isTrue(beforeResolverName)) {
            throw new InvalidUserDataException("You must specify beforeResolverName");
        }
        final ArtifactRepository before = (ArtifactRepository)this.getByName(beforeResolverName);
        return this.addCustomDependencyResolver(userDescription, configureClosure, new Action<ArtifactRepository>(){

            public void execute(ArtifactRepository repository) {
                int insertPos = DefaultArtifactRepositoryContainer.this.indexOf(before) + 1;
                if (insertPos == DefaultArtifactRepositoryContainer.this.size()) {
                    DefaultArtifactRepositoryContainer.super.add(repository);
                } else {
                    DefaultArtifactRepositoryContainer.this.add(insertPos, repository);
                }
            }
        });
    }

    private DependencyResolver addCustomDependencyResolver(Object userDescription, Closure configureClosure, Action<ArtifactRepository> orderAction) {
        ArtifactRepository repository = this.baseRepositoryFactory.createRepository(userDescription);
        DependencyResolver resolver = this.baseRepositoryFactory.toResolver(repository);
        ConfigureUtil.configure(configureClosure, resolver);
        FixedResolverArtifactRepository resolverRepository = this.baseRepositoryFactory.createResolverBackedRepository(resolver);
        this.addRepository(resolverRepository, "repository", orderAction);
        return resolver;
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownRepositoryException(String.format("Repository with name '%s' not found.", name));
    }

    @Override
    public List<DependencyResolver> getResolvers() {
        ArrayList<DependencyResolver> returnedResolvers = new ArrayList<DependencyResolver>();
        for (ArtifactRepository repository : this) {
            returnedResolvers.add(this.baseRepositoryFactory.toResolver(repository));
        }
        return returnedResolvers;
    }

    public <T extends ArtifactRepository> T addRepository(T repository, Closure closure, String defaultName) {
        return this.addRepository(repository, closure, defaultName, this.addLastAction);
    }

    public <T extends ArtifactRepository> T addRepository(T repository, Map<String, ?> args, Closure closure, String defaultName) {
        ConfigureUtil.configureByMap(args, repository);
        return this.addRepository(repository, closure, defaultName);
    }

    protected <T extends ArtifactRepository> T addRepository(T repository, Closure closure, String defaultName, Action<ArtifactRepository> action) {
        ConfigureUtil.configure(closure, repository);
        return this.addRepository(repository, defaultName, action);
    }

    public <T extends ArtifactRepository> T addRepository(T repository, Map<String, ?> args, String defaultName) {
        ConfigureUtil.configureByMap(args, repository);
        this.addRepository(repository, defaultName);
        return repository;
    }

    public <T extends ArtifactRepository> T addRepository(T repository, String defaultName) {
        return this.addRepository(repository, defaultName, this.addLastAction);
    }

    protected <T extends ArtifactRepository> T addRepository(T repository, String defaultName, Action<ArtifactRepository> action) {
        String repositoryName = repository.getName();
        if (!GUtil.isTrue(repositoryName)) {
            repositoryName = this.uniquifyName(defaultName);
            repository.setName(repositoryName);
        }
        this.assertCanAdd(repositoryName);
        action.execute(repository);
        ((ArtifactRepositoryInternal)Cast.cast(ArtifactRepositoryInternal.class, repository)).onAddToContainer(this);
        return repository;
    }

    protected <T extends ArtifactRepository> T addRepository(T repository) {
        return (T)this.addRepository(repository, this.addLastAction);
    }

    protected <T extends ArtifactRepository> T addRepository(T repository, Action<? super T> insertion) {
        repository.setName(this.uniquifyName(repository.getName()));
        this.assertCanAdd(repository.getName());
        insertion.execute(repository);
        ((ArtifactRepositoryInternal)Cast.cast(ArtifactRepositoryInternal.class, repository)).onAddToContainer(this);
        return repository;
    }

    private String uniquifyName(String proposedName) {
        if (this.findByName(proposedName) == null) {
            return proposedName;
        }
        int index = 2;
        String candidate;
        while (this.findByName(candidate = String.format("%s%d", proposedName, index)) != null) {
            ++index;
        }
        return candidate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryNamer
    implements Namer<ArtifactRepository> {
        private RepositoryNamer() {
        }

        public String determineName(ArtifactRepository r) {
            return r.getName();
        }
    }
}

