/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CachingDirectedGraphWalker;
import org.gradle.api.internal.DirectedGraph;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.ResolvableDependency;
import org.gradle.api.internal.file.UnionFileCollection;

public class CachingDependencyResolveContext
implements DependencyResolveContext {
    private final List<Object> queue = new ArrayList<Object>();
    private final CachingDirectedGraphWalker<Object, FileCollection> walker = new CachingDirectedGraphWalker<Object, FileCollection>(new DependencyGraph());
    private final boolean transitive;

    public CachingDependencyResolveContext(boolean transitive) {
        this.transitive = transitive;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCollection resolve() {
        try {
            this.walker.add((Iterable<Object>)this.queue);
            UnionFileCollection unionFileCollection = new UnionFileCollection(this.walker.findValues());
            return unionFileCollection;
        }
        finally {
            this.queue.clear();
        }
    }

    public void add(Object dependency) {
        this.queue.add(dependency);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependencyGraph
    implements DirectedGraph<Object, FileCollection> {
        private DependencyGraph() {
        }

        @Override
        public void getNodeValues(Object node, Collection<FileCollection> values, Collection<Object> connectedNodes) {
            if (node instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)node;
                values.add(fileCollection);
            } else if (node instanceof ResolvableDependency) {
                ResolvableDependency resolvableDependency = (ResolvableDependency)node;
                CachingDependencyResolveContext.this.queue.clear();
                resolvableDependency.resolve(CachingDependencyResolveContext.this);
                connectedNodes.addAll(CachingDependencyResolveContext.this.queue);
                CachingDependencyResolveContext.this.queue.clear();
            } else {
                throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s.", node.getClass().getSimpleName()));
            }
        }
    }
}

