/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.util.GradleVersion;

public class DocumentationRegistry {
    private final GradleDistributionLocator locator;
    private final GradleVersion gradleVersion;

    public DocumentationRegistry(GradleDistributionLocator locator) {
        this(locator, GradleVersion.current());
    }

    public DocumentationRegistry(GradleDistributionLocator locator, GradleVersion gradleVersion) {
        this.locator = locator;
        this.gradleVersion = gradleVersion;
    }

    public String getDocumentationFor(String id) {
        if (this.locator.getGradleHome() != null) {
            File pageLocation = new File(this.locator.getGradleHome(), String.format("docs/userguide/%s.html", id));
            File userGuideLocation = new File(this.locator.getGradleHome(), "docs/userguide/userguide.html");
            if (pageLocation.isFile() && userGuideLocation.isFile()) {
                return pageLocation.getAbsolutePath();
            }
            if (!pageLocation.isFile() && userGuideLocation.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", pageLocation));
            }
            if (pageLocation.isFile() && !userGuideLocation.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", userGuideLocation));
            }
        }
        return String.format("http://gradle.org/docs/%s/userguide/%s.html", this.gradleVersion.getVersion(), id);
    }

    public String getFeatureLifecycle() {
        return this.getDocumentationFor("feature_lifecycle");
    }
}

