/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.HashMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.NoConventionMapping;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.reflect.DirectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Map<Class<?>, Map<Class<?>, Class<?>>> GENERATED_CLASSES = new HashMap();

    public <T> T newInstance(Class<T> type, Object ... parameters) {
        DirectInstantiator instantiator = new DirectInstantiator();
        return (T)instantiator.newInstance(this.generate(type), parameters);
    }

    @Override
    public <T> Class<? extends T> generate(Class<T> type) {
        Class<T> subclass;
        Class<?> generatedClass;
        ReferenceMap cache = GENERATED_CLASSES.get(this.getClass());
        if (cache == null) {
            cache = new ReferenceMap(2, 2);
            GENERATED_CLASSES.put(this.getClass(), (Map<Class<?>, Class<?>>)cache);
        }
        if ((generatedClass = cache.get(type)) != null) {
            return generatedClass.asSubclass(type);
        }
        if (Modifier.isPrivate(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for private class '%s'.", type.getSimpleName()));
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for abstract class '%s'.", type.getSimpleName()));
        }
        try {
            ClassBuilder<T> builder = this.start(type);
            boolean isConventionAware = type.getAnnotation(NoConventionMapping.class) == null;
            builder.startClass(isConventionAware);
            if (!DynamicObjectAware.class.isAssignableFrom(type)) {
                if (ExtensionAware.class.isAssignableFrom(type)) {
                    throw new UnsupportedOperationException("A type that implements ExtensionAware must currently also implement DynamicObjectAware.");
                }
                builder.mixInDynamicAware();
            }
            if (!GroovyObject.class.isAssignableFrom(type)) {
                builder.mixInGroovyObject();
            }
            builder.addDynamicMethods();
            if (isConventionAware && !IConventionAware.class.isAssignableFrom(type)) {
                builder.mixInConventionAware();
            }
            Class noMappingClass = Object.class;
            for (Class<T> c = type; c != null && noMappingClass == Object.class; c = c.getSuperclass()) {
                if (c.getAnnotation(NoConventionMapping.class) == null) continue;
                noMappingClass = c;
            }
            List<String> skipProperties = Arrays.asList("metaClass", "conventionMapping", "convention", "asDynamicObject", "extensions");
            HashSet<MetaBeanProperty> settableProperties = new HashSet<MetaBeanProperty>();
            HashSet<MetaBeanProperty> conventionProperties = new HashSet<MetaBeanProperty>();
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(type);
            for (MetaProperty property : metaClass.getProperties()) {
                MetaMethod setter;
                if (skipProperties.contains(property.getName()) || !(property instanceof MetaBeanProperty)) continue;
                MetaBeanProperty metaBeanProperty = (MetaBeanProperty)property;
                boolean needsConventionMapping = true;
                MetaMethod getter = metaBeanProperty.getGetter();
                if (getter == null) {
                    needsConventionMapping = false;
                } else if (Modifier.isFinal(getter.getModifiers()) || Modifier.isPrivate(getter.getModifiers())) {
                    needsConventionMapping = false;
                } else {
                    Class declaringClass = getter.getDeclaringClass().getTheClass();
                    if (declaringClass.isAssignableFrom(noMappingClass)) {
                        needsConventionMapping = false;
                    }
                }
                if (needsConventionMapping) {
                    conventionProperties.add(metaBeanProperty);
                    builder.addGetter(metaBeanProperty);
                }
                if ((setter = metaBeanProperty.getSetter()) == null || Modifier.isPrivate(setter.getModifiers())) continue;
                if (needsConventionMapping && !Modifier.isFinal(setter.getModifiers())) {
                    builder.addSetter(metaBeanProperty);
                }
                if (Iterable.class.isAssignableFrom(property.getType())) continue;
                settableProperties.add(metaBeanProperty);
            }
            HashMultimap methods = HashMultimap.create();
            HashSet<MetaMethod> actionMethods = new HashSet<MetaMethod>();
            for (MetaMethod method : metaClass.getMethods()) {
                CachedClass[] parameterTypes;
                if (method.isPrivate() || (parameterTypes = method.getParameterTypes()).length == 0) continue;
                methods.put((Object)method.getName(), (Object)method);
                CachedClass lastParameter = parameterTypes[parameterTypes.length - 1];
                if (!lastParameter.getTheClass().equals(Action.class)) continue;
                actionMethods.add(method);
            }
            for (MetaMethod method : actionMethods) {
                boolean hasClosure = false;
                Class[] actionMethodParameterTypes = method.getNativeParameterTypes();
                int numParams = actionMethodParameterTypes.length;
                Object[] closureMethodParameterTypes = new Class[actionMethodParameterTypes.length];
                System.arraycopy(actionMethodParameterTypes, 0, closureMethodParameterTypes, 0, actionMethodParameterTypes.length);
                closureMethodParameterTypes[numParams - 1] = Closure.class;
                for (MetaMethod otherMethod : methods.get((Object)method.getName())) {
                    if (!Arrays.equals(otherMethod.getNativeParameterTypes(), closureMethodParameterTypes)) continue;
                    hasClosure = true;
                    break;
                }
                if (hasClosure) continue;
                builder.addActionMethod(method);
            }
            for (MetaBeanProperty property : settableProperties) {
                Collection methodsForProperty = methods.get((Object)property.getName());
                if (methodsForProperty.isEmpty()) {
                    builder.addSetMethod(property);
                    continue;
                }
                if (!conventionProperties.contains(property)) continue;
                for (MetaMethod method : methodsForProperty) {
                    builder.overrideSetMethod(property, method);
                }
            }
            for (Constructor<?> constructor : type.getConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                builder.addConstructor(constructor);
            }
            subclass = builder.generate();
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not generate a proxy class for class %s.", type.getName()), e);
        }
        cache.put(type, subclass);
        cache.put(subclass, subclass);
        return subclass;
    }

    protected abstract <T> ClassBuilder<T> start(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ClassBuilder<T> {
        public void startClass(boolean var1);

        public void addConstructor(Constructor<?> var1) throws Exception;

        public void mixInDynamicAware() throws Exception;

        public void mixInConventionAware() throws Exception;

        public void mixInGroovyObject() throws Exception;

        public void addDynamicMethods() throws Exception;

        public void addGetter(MetaBeanProperty var1) throws Exception;

        public void addSetter(MetaBeanProperty var1) throws Exception;

        public void overrideSetMethod(MetaBeanProperty var1, MetaMethod var2) throws Exception;

        public void addSetMethod(MetaBeanProperty var1) throws Exception;

        public Class<? extends T> generate() throws Exception;

        public void addActionMethod(MetaMethod var1) throws Exception;
    }
}

