/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.gradle.api.GradleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod<T, R> {
    private final Method method;
    private final Class<R> returnType;

    private JavaMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        this.returnType = returnType;
        this.method = this.findMethod(target, name, paramTypes);
        this.method.setAccessible(true);
    }

    private JavaMethod(Class<T> target, Class<R> returnType, Method method) {
        this.returnType = returnType;
        this.method = method;
        method.setAccessible(true);
    }

    private Method findMethod(Class target, String name, Class<?>[] paramTypes) {
        for (Method method : target.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        throw new GradleException(String.format("Could not find method %s(%s) on %s", name, Arrays.toString(paramTypes), target));
    }

    public R invoke(T target, Object ... args) {
        try {
            return this.returnType.cast(this.method.invoke(target, args));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), target), cause);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), target), (Throwable)e);
        }
    }

    public static <T, R> JavaMethod<T, R> create(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> create(Class<T> target, Class<R> returnType, Method method) {
        return new JavaMethod<T, R>(target, returnType, method);
    }
}

