/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.util.ClassLoaderFactory;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    @Override
    public ClassLoader createIsolatedClassLoader(Iterable<URI> uris) {
        return this.doCreateIsolatedClassLoader(GFileUtils.urisToUrls(uris));
    }

    @Override
    public ClassLoader createIsolatedClassLoader(ClassPath classPath) {
        return this.doCreateIsolatedClassLoader(classPath.getAsURLs());
    }

    private ClassLoader doCreateIsolatedClassLoader(Collection<URL> classpath) {
        if (this.needJaxpImpl()) {
            try {
                classpath.add(ClasspathUtil.getClasspathForResource(ClassLoader.getSystemClassLoader(), "META-INF/services/javax.xml.parsers.SAXParserFactory").toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ClassLoader.getSystemClassLoader().getParent());
    }

    @Override
    public FilteringClassLoader createFilteringClassLoader(ClassLoader parent) {
        FilteringClassLoader classLoader = new FilteringClassLoader(parent);
        if (this.needJaxpImpl()) {
            ServiceLocator locator = new ServiceLocator(ClassLoader.getSystemClassLoader());
            this.makeServiceVisible(locator, classLoader, SAXParserFactory.class);
            this.makeServiceVisible(locator, classLoader, DocumentBuilderFactory.class);
            this.makeServiceVisible(locator, classLoader, DatatypeFactory.class);
        }
        return classLoader;
    }

    private void makeServiceVisible(ServiceLocator locator, FilteringClassLoader classLoader, Class<?> serviceType) {
        classLoader.allowClass(locator.getFactory(serviceType).getImplementationClass());
        classLoader.allowResource("META-INF/services/" + serviceType.getName());
    }

    private boolean needJaxpImpl() {
        return ClassLoader.getSystemResource("META-INF/services/javax.xml.parsers.SAXParserFactory") != null;
    }
}

