/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.GlobalTestServices;
import org.gradle.testfixtures.internal.TestTopLevelBuildServiceRegistry;
import org.gradle.util.GFileUtils;

public class ProjectBuilderImpl {
    private static final GlobalTestServices GLOBAL_SERVICES = new GlobalTestServices();
    private static final AsmBackedClassGenerator CLASS_GENERATOR = new AsmBackedClassGenerator();

    public Project createChildProject(String name, Project parent, File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        DefaultProject project = CLASS_GENERATOR.newInstance(DefaultProject.class, name, parentProject, projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name), new StringScriptSource("test build file", null), parentProject.getGradle(), parentProject.getGradle().getServices());
        parentProject.addChildProject(project);
        parentProject.getProjectRegistry().addProject(project);
        return project;
    }

    public Project createProject(String name, File inputProjectDir) {
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File homeDir = new File(projectDir, "gradleHome");
        StartParameter startParameter = new StartParameter();
        startParameter.setGradleUserHomeDir(new File(projectDir, "userHome"));
        TestTopLevelBuildServiceRegistry topLevelRegistry = new TestTopLevelBuildServiceRegistry((ServiceRegistry)GLOBAL_SERVICES, startParameter, homeDir);
        DefaultGradle gradle = new DefaultGradle(null, startParameter, topLevelRegistry);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, new DefaultProjectDescriptorRegistry());
        ProjectInternal project = ((IProjectFactory)topLevelRegistry.get(IProjectFactory.class)).createProject(projectDescriptor, null, gradle);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        gradle.getScriptClassLoader().addParent(this.getClass().getClassLoader());
        return project;
    }

    public File prepareProjectDir(File projectDir) {
        if (projectDir == null) {
            TmpDirTemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
            projectDir = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            projectDir.deleteOnExit();
        } else {
            projectDir = GFileUtils.canonicalise(projectDir);
        }
        return projectDir;
    }
}

