/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.util.ArrayList;
import java.util.List;
import org.gradle.reporting.DomReportRenderer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsRenderer<T>
extends DomReportRenderer<T> {
    private final List<TabDefinition> tabs = new ArrayList<TabDefinition>();

    public void add(String title, DomReportRenderer<T> contentRenderer) {
        this.tabs.add(new TabDefinition(title, contentRenderer));
    }

    public void clear() {
        this.tabs.clear();
    }

    @Override
    public void render(T model, Element parent) {
        Element tabs = this.appendWithId(parent, "div", "tabs");
        Element ul = this.append(tabs, "ul");
        ul.setAttribute("class", "tabLinks");
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabDefinition tab = this.tabs.get(i);
            Element li = this.append(ul, "li");
            Element a = this.appendWithText(li, "a", tab.title);
            String tabId = String.format("tab%s", i);
            a.setAttribute("href", "#" + tabId);
            Element tabDiv = this.appendWithId(tabs, "div", tabId);
            tabDiv.setAttribute("class", "tab");
            this.appendWithText(tabDiv, "h2", tab.title);
            tab.renderer.render(model, tabDiv);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabDefinition {
        final String title;
        final DomReportRenderer<T> renderer;

        private TabDefinition(String title, DomReportRenderer<T> renderer) {
            this.title = title;
            this.renderer = renderer;
        }
    }
}

