/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.text.DateFormat;
import java.util.Date;
import org.gradle.reporting.DomReportRenderer;
import org.gradle.util.GradleVersion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabbedPageRenderer<T>
extends DomReportRenderer<T> {
    private T model;

    protected T getModel() {
        return this.model;
    }

    protected abstract String getTitle();

    protected String getPageTitle() {
        return this.getTitle();
    }

    protected abstract DomReportRenderer<T> getHeaderRenderer();

    protected abstract DomReportRenderer<T> getContentRenderer();

    @Override
    public void render(T model, Element parent) {
        this.model = model;
        Element head = this.append(parent, "head");
        this.appendWithText(head, "title", this.getPageTitle());
        Element link = this.append(head, "link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("href", "base-style.css");
        link.setAttribute("type", "text/css");
        link = this.append(head, "link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("href", "style.css");
        link.setAttribute("type", "text/css");
        Element script = this.append(head, "script");
        script.setAttribute("src", "report.js");
        script.setAttribute("type", "text/javascript");
        Element body = this.append(parent, "body");
        Element content = this.appendWithId(body, "div", "content");
        this.appendWithText(content, "h1", this.getTitle());
        this.getHeaderRenderer().render(model, content);
        this.getContentRenderer().render(model, content);
        Element footer = this.appendWithId(content, "div", "footer");
        Element footerText = this.append(footer, "p");
        this.appendText(footerText, "Generated by ");
        this.appendLink(footerText, "http://www.gradle.org/", String.format("Gradle %s", GradleVersion.current().getVersion()));
        this.appendText(footerText, String.format(" at %s", DateFormat.getDateTimeInstance().format(new Date())));
    }
}

