/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.PrintStream;
import org.gradle.api.Action;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.logging.StandardOutputRedirector;
import org.gradle.util.LinePerThreadBufferingOutputStream;

public class DefaultStandardOutputRedirector
implements StandardOutputRedirector {
    private PrintStream originalStdOut;
    private PrintStream originalStdErr;
    private final WriteAction stdOut = new WriteAction();
    private final WriteAction stdErr = new WriteAction();
    private final PrintStream redirectedStdOut = new LinePerThreadBufferingOutputStream(this.stdOut);
    private final PrintStream redirectedStdErr = new LinePerThreadBufferingOutputStream(this.stdErr);

    public void redirectStandardOutputTo(StandardOutputListener stdOutDestination) {
        this.stdOut.setDestination(stdOutDestination);
    }

    public void redirectStandardErrorTo(StandardOutputListener stdErrDestination) {
        this.stdErr.setDestination(stdErrDestination);
    }

    public StandardOutputCapture start() {
        if (this.stdOut.destination != null) {
            this.originalStdOut = System.out;
            System.setOut(this.redirectedStdOut);
        }
        if (this.stdErr.destination != null) {
            this.originalStdErr = System.err;
            System.setErr(this.redirectedStdErr);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardOutputCapture stop() {
        try {
            if (this.originalStdOut != null) {
                System.setOut(this.originalStdOut);
            }
            if (this.originalStdErr != null) {
                System.setErr(this.originalStdErr);
            }
            this.redirectedStdOut.flush();
            this.redirectedStdErr.flush();
        }
        finally {
            this.originalStdOut = null;
            this.originalStdErr = null;
            this.stdOut.setDestination(new DiscardAction());
            this.stdErr.setDestination(new DiscardAction());
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WriteAction
    implements Action<String> {
        private StandardOutputListener destination;

        private WriteAction() {
        }

        public void execute(String message) {
            this.destination.onOutput(message);
        }

        public void setDestination(StandardOutputListener destination) {
            this.destination = destination;
        }
    }

    private static class DiscardAction
    implements StandardOutputListener {
        private DiscardAction() {
        }

        public void onOutput(CharSequence output) {
        }
    }
}

