/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.internal.SystemProperties;
import org.gradle.logging.internal.AbstractStyledTextOutput;

public abstract class AbstractLineChoppingStyledTextOutput
extends AbstractStyledTextOutput {
    private final char[] eol = SystemProperties.getLineSeparator().toCharArray();
    private int seenCharsFromEol;

    protected AbstractLineChoppingStyledTextOutput() {
    }

    protected final void doAppend(String text) {
        int max = text.length();
        int pos = 0;
        int start = 0;
        while (pos < max) {
            if (this.seenCharsFromEol == this.eol.length) {
                this.doStartLine();
                this.seenCharsFromEol = 0;
            }
            if (this.seenCharsFromEol < this.eol.length && text.charAt(pos) == this.eol[this.seenCharsFromEol]) {
                ++this.seenCharsFromEol;
                ++pos;
                if (this.seenCharsFromEol != this.eol.length) continue;
                this.doLineText(text.substring(start, pos), true);
                this.doFinishLine();
                start = pos;
                continue;
            }
            this.seenCharsFromEol = 0;
            ++pos;
        }
        if (pos > start) {
            this.doLineText(text.substring(start, pos), false);
        }
    }

    protected void doFinishLine() {
    }

    protected void doStartLine() {
    }

    protected abstract void doLineText(CharSequence var1, boolean var2);
}

