/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.BuildFileProjectSpec;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.DefaultProjectSpec;
import org.gradle.initialization.ProjectDirectoryProjectSpec;

public class InstantiatingBuildLoader
implements BuildLoader {
    private final IProjectFactory projectFactory;

    public InstantiatingBuildLoader(IProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
    }

    public void load(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle) {
        this.createProjects(rootProjectDescriptor, gradle);
        this.attachDefaultProject(gradle);
    }

    private void attachDefaultProject(GradleInternal gradle) {
        File explicitProjectDir = gradle.getStartParameter().getProjectDir();
        File explicitBuildFile = gradle.getStartParameter().getBuildFile();
        AbstractProjectSpec spec = explicitBuildFile != null ? new BuildFileProjectSpec(explicitBuildFile) : (explicitProjectDir == null ? new DefaultProjectSpec(gradle.getStartParameter().getCurrentDir()) : new ProjectDirectoryProjectSpec(explicitProjectDir));
        try {
            gradle.setDefaultProject(spec.selectProject(gradle.getRootProject().getProjectRegistry()));
        }
        catch (InvalidUserDataException e) {
            throw new GradleException(String.format("Could not select the default project for this build. %s", e.getMessage()), (Throwable)((Object)e));
        }
    }

    private void createProjects(ProjectDescriptor rootProjectDescriptor, GradleInternal gradle) {
        ProjectInternal rootProject = this.projectFactory.createProject(rootProjectDescriptor, null, gradle);
        gradle.setRootProject(rootProject);
        this.addProjects(rootProject, rootProjectDescriptor, gradle);
    }

    private void addProjects(ProjectInternal parent, ProjectDescriptor parentProjectDescriptor, GradleInternal gradle) {
        for (ProjectDescriptor childProjectDescriptor : parentProjectDescriptor.getChildren()) {
            ProjectInternal childProject = this.projectFactory.createProject(childProjectDescriptor, parent, gradle);
            this.addProjects(childProject, childProjectDescriptor, gradle);
        }
    }
}

