/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.RefreshOptions;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ProjectPropertiesCommandLineConverter;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.internal.LoggingCommandLineConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandLineConverter
extends AbstractCommandLineConverter<StartParameter> {
    private static final String NO_SEARCH_UPWARDS = "u";
    private static final String PROJECT_DIR = "p";
    private static final String NO_PROJECT_DEPENDENCY_REBUILD = "a";
    private static final String BUILD_FILE = "b";
    public static final String INIT_SCRIPT = "I";
    private static final String SETTINGS_FILE = "c";
    public static final String GRADLE_USER_HOME = "g";
    private static final String CACHE = "C";
    private static final String DRY_RUN = "m";
    private static final String NO_OPT = "no-opt";
    private static final String RERUN_TASKS = "rerun-tasks";
    private static final String EXCLUDE_TASK = "x";
    private static final String PROFILE = "profile";
    private static final String CONTINUE = "continue";
    private static final String OFFLINE = "offline";
    private static final String REFRESH = "refresh";
    private static final String REFRESH_DEPENDENCIES = "refresh-dependencies";
    private static final String PROJECT_CACHE_DIR = "project-cache-dir";
    private static final String RECOMPILE_SCRIPTS = "recompile-scripts";
    private static final String PARALLEL = "parallel";
    private static final String PARALLEL_THREADS = "parallel-threads";
    private final CommandLineConverter<LoggingConfiguration> loggingConfigurationCommandLineConverter = new LoggingCommandLineConverter();
    private final SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
    private final ProjectPropertiesCommandLineConverter projectPropertiesCommandLineConverter = new ProjectPropertiesCommandLineConverter();

    public void configure(CommandLineParser parser) {
        this.loggingConfigurationCommandLineConverter.configure(parser);
        this.systemPropertiesCommandLineConverter.configure(parser);
        this.projectPropertiesCommandLineConverter.configure(parser);
        parser.allowMixedSubcommandsAndOptions();
        parser.option(new String[]{NO_SEARCH_UPWARDS, "no-search-upward"}).hasDescription(String.format("Don't search in parent folders for a %s file.", "settings.gradle"));
        parser.option(new String[]{CACHE, "cache"}).hasArgument().hasDescription("Specifies how compiled build scripts should be cached. Possible values are: 'rebuild' and 'on'. Default value is 'on'").deprecated("Use '--rerun-tasks' or '--recompile-scripts' instead");
        parser.option(new String[]{PROJECT_CACHE_DIR}).hasArgument().hasDescription("Specifies the project-specific cache directory. Defaults to .gradle in the root project directory.");
        parser.option(new String[]{DRY_RUN, "dry-run"}).hasDescription("Runs the builds with all task actions disabled.");
        parser.option(new String[]{PROJECT_DIR, "project-dir"}).hasArgument().hasDescription("Specifies the start directory for Gradle. Defaults to current directory.");
        parser.option(new String[]{GRADLE_USER_HOME, "gradle-user-home"}).hasArgument().hasDescription("Specifies the gradle user home directory.");
        parser.option(new String[]{INIT_SCRIPT, "init-script"}).hasArguments().hasDescription("Specifies an initialization script.");
        parser.option(new String[]{SETTINGS_FILE, "settings-file"}).hasArgument().hasDescription("Specifies the settings file.");
        parser.option(new String[]{BUILD_FILE, "build-file"}).hasArgument().hasDescription("Specifies the build file.");
        parser.option(new String[]{NO_PROJECT_DEPENDENCY_REBUILD, "no-rebuild"}).hasDescription("Do not rebuild project dependencies.");
        parser.option(new String[]{NO_OPT}).hasDescription("Ignore any task optimization.").deprecated("Use '--rerun-tasks' instead");
        parser.option(new String[]{RERUN_TASKS}).hasDescription("Ignore previously cached task results.");
        parser.option(new String[]{RECOMPILE_SCRIPTS}).hasDescription("Force build script recompiling.");
        parser.option(new String[]{EXCLUDE_TASK, "exclude-task"}).hasArguments().hasDescription("Specify a task to be excluded from execution.");
        parser.option(new String[]{PROFILE}).hasDescription("Profiles build execution time and generates a report in the <build_dir>/reports/profile directory.");
        parser.option(new String[]{CONTINUE}).hasDescription("Continues task execution after a task failure.");
        parser.option(new String[]{OFFLINE}).hasDescription("The build should operate without accessing network resources.");
        parser.option(new String[]{REFRESH}).hasArguments().hasDescription("Refresh the state of resources of the type(s) specified. Currently only 'dependencies' is supported.").deprecated("Use '--refresh-dependencies' instead.");
        parser.option(new String[]{REFRESH_DEPENDENCIES}).hasDescription("Refresh the state of dependencies.");
        parser.option(new String[]{PARALLEL}).hasDescription("Build projects in parallel. Gradle will attempt to determine the optimal number of executor threads to use.").incubating();
        parser.option(new String[]{PARALLEL_THREADS}).hasArgument().hasDescription("Build projects in parallel, using the specified number of executor threads.").incubating();
    }

    protected StartParameter newInstance() {
        return new StartParameter();
    }

    public StartParameter convert(ParsedCommandLine options, StartParameter startParameter) throws CommandLineArgumentException {
        this.loggingConfigurationCommandLineConverter.convert(options, (Object)startParameter);
        BaseDirFileResolver resolver = new BaseDirFileResolver(FileSystems.getDefault(), startParameter.getCurrentDir());
        Map systemProperties = (Map)this.systemPropertiesCommandLineConverter.convert(options);
        this.convertCommandLineSystemProperties(systemProperties, startParameter, resolver);
        Map projectProperties = (Map)this.projectPropertiesCommandLineConverter.convert(options);
        startParameter.getProjectProperties().putAll(projectProperties);
        if (options.hasOption(NO_SEARCH_UPWARDS)) {
            startParameter.setSearchUpwards(false);
        }
        if (options.hasOption(PROJECT_DIR)) {
            startParameter.setProjectDir(resolver.resolve(options.option(PROJECT_DIR).getValue()));
        }
        if (options.hasOption(GRADLE_USER_HOME)) {
            startParameter.setGradleUserHomeDir(resolver.resolve(options.option(GRADLE_USER_HOME).getValue()));
        }
        if (options.hasOption(BUILD_FILE)) {
            startParameter.setBuildFile(resolver.resolve(options.option(BUILD_FILE).getValue()));
        }
        if (options.hasOption(SETTINGS_FILE)) {
            startParameter.setSettingsFile(resolver.resolve(options.option(SETTINGS_FILE).getValue()));
        }
        for (String script : options.option(INIT_SCRIPT).getValues()) {
            startParameter.addInitScript(resolver.resolve(script));
        }
        if (options.hasOption(CACHE)) {
            try {
                startParameter.setCacheUsage(CacheUsage.fromString(options.option(CACHE).getValue()));
            }
            catch (InvalidUserDataException e) {
                throw new CommandLineArgumentException(e.getMessage());
            }
        }
        if (options.hasOption(PROJECT_CACHE_DIR)) {
            startParameter.setProjectCacheDir(resolver.resolve(options.option(PROJECT_CACHE_DIR).getValue()));
        }
        if (options.hasOption(NO_PROJECT_DEPENDENCY_REBUILD)) {
            startParameter.setBuildProjectDependencies(false);
        }
        if (!options.getExtraArguments().isEmpty()) {
            startParameter.setTaskNames(options.getExtraArguments());
        }
        if (options.hasOption(DRY_RUN)) {
            startParameter.setDryRun(true);
        }
        if (options.hasOption(NO_OPT)) {
            startParameter.setNoOpt(true);
        }
        if (options.hasOption(RERUN_TASKS)) {
            startParameter.setRerunTasks(true);
        }
        if (options.hasOption(RECOMPILE_SCRIPTS)) {
            startParameter.setRecompileScripts(true);
        }
        if (options.hasOption(EXCLUDE_TASK)) {
            startParameter.setExcludedTaskNames(options.option(EXCLUDE_TASK).getValues());
        }
        if (options.hasOption(PROFILE)) {
            startParameter.setProfile(true);
        }
        if (options.hasOption(CONTINUE)) {
            startParameter.setContinueOnFailure(true);
        }
        if (options.hasOption(OFFLINE)) {
            startParameter.setOffline(true);
        }
        if (options.hasOption(REFRESH)) {
            startParameter.setRefreshOptions(RefreshOptions.fromCommandLineOptions(options.option(REFRESH).getValues()));
        }
        if (options.hasOption(REFRESH_DEPENDENCIES)) {
            startParameter.setRefreshDependencies(true);
        }
        if (options.hasOption(PARALLEL)) {
            startParameter.setParallelThreadCount(-1);
        }
        if (options.hasOption(PARALLEL_THREADS)) {
            try {
                int parallelThreads = Integer.parseInt(options.option(PARALLEL_THREADS).getValue());
                startParameter.setParallelThreadCount(parallelThreads);
            }
            catch (NumberFormatException e) {
                throw new CommandLineArgumentException(String.format("Not a numeric argument for %s", PARALLEL_THREADS));
            }
        }
        return startParameter;
    }

    void convertCommandLineSystemProperties(Map<String, String> systemProperties, StartParameter startParameter, FileResolver resolver) {
        startParameter.getSystemPropertiesArgs().putAll(systemProperties);
        String gradleUserHomeProp = "gradle.user.home";
        if (systemProperties.containsKey(gradleUserHomeProp)) {
            startParameter.setGradleUserHomeDir(resolver.resolve(systemProperties.get(gradleUserHomeProp)));
        }
    }
}

