/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;

public class TaskDefinitionScriptTransformer
extends AbstractScriptTransformer {
    protected int getPhase() {
        return 5;
    }

    public String getId() {
        return "tasks";
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        this.visitScriptCode(source, (GroovyCodeVisitor)new TaskDefinitionTransformer());
    }

    private class TaskDefinitionTransformer
    extends CodeVisitorSupport {
        private TaskDefinitionTransformer() {
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            this.doVisitMethodCallExpression(call);
            super.visitMethodCallExpression(call);
        }

        private void doVisitMethodCallExpression(MethodCallExpression call) {
            if (!this.isInstanceMethod(call, "task")) {
                return;
            }
            ArgumentListExpression args = (ArgumentListExpression)call.getArguments();
            if (args.getExpressions().size() == 0 || args.getExpressions().size() > 3) {
                return;
            }
            if (args.getExpressions().size() > 1) {
                if (args.getExpression(0) instanceof MapExpression && args.getExpression(1) instanceof VariableExpression) {
                    this.transformVariableExpression(call, 1);
                } else if (args.getExpression(0) instanceof VariableExpression) {
                    this.transformVariableExpression(call, 0);
                }
                return;
            }
            Expression arg = args.getExpression(0);
            if (arg instanceof VariableExpression) {
                this.transformVariableExpression(call, 0);
            } else if (arg instanceof BinaryExpression) {
                this.transformBinaryExpression(call, (BinaryExpression)arg);
            } else if (arg instanceof MethodCallExpression) {
                this.maybeTransformNestedMethodCall((MethodCallExpression)arg, call);
            }
        }

        private void transformVariableExpression(MethodCallExpression call, int index) {
            ArgumentListExpression args = (ArgumentListExpression)call.getArguments();
            VariableExpression arg = (VariableExpression)args.getExpression(index);
            if (!this.isDynamicVar((Expression)arg)) {
                return;
            }
            String taskName = arg.getText();
            call.setMethod((Expression)new ConstantExpression((Object)"task"));
            args.getExpressions().set(index, new ConstantExpression((Object)taskName));
        }

        private void transformBinaryExpression(MethodCallExpression call, BinaryExpression expression) {
            if (expression.getLeftExpression() instanceof VariableExpression || expression.getLeftExpression() instanceof GStringExpression || expression.getLeftExpression() instanceof ConstantExpression) {
                call.setMethod((Expression)new ConstantExpression((Object)"passThrough"));
                Object argument = expression.getLeftExpression() instanceof VariableExpression ? new ConstantExpression((Object)expression.getLeftExpression().getText()) : expression.getLeftExpression();
                expression.setLeftExpression((Expression)new MethodCallExpression(call.getObjectExpression(), "task", argument));
            } else if (expression.getLeftExpression() instanceof MethodCallExpression) {
                MethodCallExpression transformedCall = new MethodCallExpression(call.getObjectExpression(), "task", (Expression)new ArgumentListExpression());
                boolean transformed = this.maybeTransformNestedMethodCall((MethodCallExpression)expression.getLeftExpression(), transformedCall);
                if (transformed) {
                    call.setMethod((Expression)new ConstantExpression((Object)"passThrough"));
                    expression.setLeftExpression((Expression)transformedCall);
                }
            }
        }

        private boolean maybeTransformNestedMethodCall(MethodCallExpression nestedMethod, MethodCallExpression target) {
            if (!this.isTaskIdentifier(nestedMethod.getMethod()) || !TaskDefinitionScriptTransformer.this.targetIsThis(nestedMethod)) {
                return false;
            }
            Expression taskName = nestedMethod.getMethod();
            Expression mapArg = null;
            List extraArgs = Collections.emptyList();
            if (nestedMethod.getArguments() instanceof TupleExpression) {
                TupleExpression nestedArgs = (TupleExpression)nestedMethod.getArguments();
                if (nestedArgs.getExpressions().size() == 2 && nestedArgs.getExpression(0) instanceof MapExpression && nestedArgs.getExpression(1) instanceof ClosureExpression) {
                    mapArg = nestedArgs.getExpression(0);
                    extraArgs = nestedArgs.getExpressions().subList(1, nestedArgs.getExpressions().size());
                } else if (nestedArgs.getExpressions().size() == 1 && nestedArgs.getExpression(0) instanceof ClosureExpression) {
                    extraArgs = nestedArgs.getExpressions();
                } else if (nestedArgs.getExpressions().size() == 1 && nestedArgs.getExpression(0) instanceof NamedArgumentListExpression) {
                    mapArg = nestedArgs.getExpression(0);
                } else if (nestedArgs.getExpressions().size() != 0) {
                    return false;
                }
            }
            target.setMethod((Expression)new ConstantExpression((Object)"task"));
            ArgumentListExpression args = (ArgumentListExpression)target.getArguments();
            args.getExpressions().clear();
            if (mapArg != null) {
                args.addExpression(mapArg);
            }
            args.addExpression(taskName);
            for (Expression extraArg : extraArgs) {
                args.addExpression(extraArg);
            }
            return true;
        }

        private boolean isInstanceMethod(MethodCallExpression call, String name) {
            boolean isTaskMethod = TaskDefinitionScriptTransformer.this.isMethodOnThis(call, name);
            if (!isTaskMethod) {
                return false;
            }
            return call.getArguments() instanceof ArgumentListExpression;
        }

        private boolean isTaskIdentifier(Expression expression) {
            return expression instanceof ConstantExpression || expression instanceof GStringExpression;
        }

        private boolean isDynamicVar(Expression expression) {
            if (!(expression instanceof VariableExpression)) {
                return false;
            }
            VariableExpression variableExpression = (VariableExpression)expression;
            return variableExpression.getAccessedVariable() instanceof DynamicVariable;
        }
    }
}

